package physx.vehicle2;

import physx.NativeObject;

/**
 * A description of the state of transmission-related commands that are applied to a vehicle with direct drive.
 */
public class PxVehicleDirectDriveTransmissionCommandState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleDirectDriveTransmissionCommandState wrapPointer(long address) {
        return address != 0L ? new PxVehicleDirectDriveTransmissionCommandState(address) : null;
    }
    
    public static PxVehicleDirectDriveTransmissionCommandState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleDirectDriveTransmissionCommandState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleDirectDriveTransmissionCommandState() {
        address = _PxVehicleDirectDriveTransmissionCommandState();
    }
    private static native long _PxVehicleDirectDriveTransmissionCommandState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The desired gear of the input gear controller.
     */
    public PxVehicleDirectDriveTransmissionCommandStateEnum getGear() {
        checkNotNull();
        return PxVehicleDirectDriveTransmissionCommandStateEnum.forValue(_getGear(address));
    }
    private static native int _getGear(long address);

    /**
     * The desired gear of the input gear controller.
     */
    public void setGear(PxVehicleDirectDriveTransmissionCommandStateEnum value) {
        checkNotNull();
        _setGear(address, value.value);
    }
    private static native void _setGear(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
