package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleGearboxParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleGearboxParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleGearboxParams(address) : null;
    }
    
    public static PxVehicleGearboxParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleGearboxParams(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxVehicleGearboxParams
     */
    public static PxVehicleGearboxParams createAt(long address) {
        __placement_new_PxVehicleGearboxParams(address);
        PxVehicleGearboxParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxVehicleGearboxParams
     */
    public static <T> PxVehicleGearboxParams createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxVehicleGearboxParams(address);
        PxVehicleGearboxParams createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxVehicleGearboxParams(long address);

    // Constructors

    public PxVehicleGearboxParams() {
        address = _PxVehicleGearboxParams();
    }
    private static native long _PxVehicleGearboxParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The gear that denotes neutral gear
     */
    public int getNeutralGear() {
        checkNotNull();
        return _getNeutralGear(address);
    }
    private static native int _getNeutralGear(long address);

    /**
     * The gear that denotes neutral gear
     */
    public void setNeutralGear(int value) {
        checkNotNull();
        _setNeutralGear(address, value);
    }
    private static native void _setNeutralGear(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getRatios(int index) {
        checkNotNull();
        return _getRatios(address, index);
    }
    private static native float _getRatios(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setRatios(int index, float value) {
        checkNotNull();
        _setRatios(address, index, value);
    }
    private static native void _setRatios(long address, int index, float value);

    /**
     * Gear ratio applied is #ratios[currentGear]*#finalRatio
     * <p>
     * <b>Range:</b> (0, inf)<br>
     */
    public float getFinalRatio() {
        checkNotNull();
        return _getFinalRatio(address);
    }
    private static native float _getFinalRatio(long address);

    /**
     * Gear ratio applied is #ratios[currentGear]*#finalRatio
     * <p>
     * <b>Range:</b> (0, inf)<br>
     */
    public void setFinalRatio(float value) {
        checkNotNull();
        _setFinalRatio(address, value);
    }
    private static native void _setFinalRatio(long address, float value);

    /**
     * Number of gears (including reverse and neutral).
     * <p>
     * <b>Range:</b> [1, eMAX_NB_GEARS]<br>
     */
    public int getNbRatios() {
        checkNotNull();
        return _getNbRatios(address);
    }
    private static native int _getNbRatios(long address);

    /**
     * Number of gears (including reverse and neutral).
     * <p>
     * <b>Range:</b> [1, eMAX_NB_GEARS]<br>
     */
    public void setNbRatios(int value) {
        checkNotNull();
        _setNbRatios(address, value);
    }
    private static native void _setNbRatios(long address, int value);

    /**
     * Time it takes to switch gear.
     * <p>
     * <b>Range:</b> [0, inf)<br>
     * <b>Unit:</b> time
     */
    public float getSwitchTime() {
        checkNotNull();
        return _getSwitchTime(address);
    }
    private static native float _getSwitchTime(long address);

    /**
     * Time it takes to switch gear.
     * <p>
     * <b>Range:</b> [0, inf)<br>
     * <b>Unit:</b> time
     */
    public void setSwitchTime(float value) {
        checkNotNull();
        _setSwitchTime(address, value);
    }
    private static native void _setSwitchTime(long address, float value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleGearboxParams} [Value]
     */
    public PxVehicleGearboxParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleGearboxParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
