package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class VHACDVertex extends NativeObject {

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.VHACDVertex");
    }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static VHACDVertex wrapPointer(long address) {
        return address != 0L ? new VHACDVertex(address) : null;
    }
    
    public static VHACDVertex arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected VHACDVertex(long address) {
        super(address);
    }

    // Constructors

    public VHACDVertex() {
        address = _VHACDVertex();
    }
    private static native long _VHACDVertex();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: double
     */
    public double getMX() {
        checkNotNull();
        return _getMX(address);
    }
    private static native double _getMX(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setMX(double value) {
        checkNotNull();
        _setMX(address, value);
    }
    private static native void _setMX(long address, double value);

    /**
     * @return WebIDL type: double
     */
    public double getMY() {
        checkNotNull();
        return _getMY(address);
    }
    private static native double _getMY(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setMY(double value) {
        checkNotNull();
        _setMY(address, value);
    }
    private static native void _setMY(long address, double value);

    /**
     * @return WebIDL type: double
     */
    public double getMZ() {
        checkNotNull();
        return _getMZ(address);
    }
    private static native double _getMZ(long address);

    /**
     * @param value WebIDL type: double
     */
    public void setMZ(double value) {
        checkNotNull();
        _setMZ(address, value);
    }
    private static native void _setMZ(long address, double value);

}
