package physx.vhacd;

import physx.NativeObject;
import physx.PlatformChecks;

public class Vector_VHACDVertex extends NativeObject {

    static {
        PlatformChecks.requirePlatform(15, "physx.vhacd.Vector_VHACDVertex");
    }

    protected Vector_VHACDVertex() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static Vector_VHACDVertex wrapPointer(long address) {
        return address != 0L ? new Vector_VHACDVertex(address) : null;
    }
    
    public static Vector_VHACDVertex arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected Vector_VHACDVertex(long address) {
        super(address);
    }

    // Placed Constructors

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link VHACDVertex} [Ref]
     */
    public VHACDVertex at(int index) {
        checkNotNull();
        return VHACDVertex.wrapPointer(_at(address, index));
    }
    private static native long _at(long address, int index);

    /**
     * @return WebIDL type: {@link VHACDVertex}
     */
    public VHACDVertex data() {
        checkNotNull();
        return VHACDVertex.wrapPointer(_data(address));
    }
    private static native long _data(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link VHACDVertex} [Ref]
     */
    public void push_back(VHACDVertex value) {
        checkNotNull();
        _push_back(address, value.getAddress());
    }
    private static native void _push_back(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
