package physx.character;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxShape;

/**
 * Describes a controller's internal state.
 */
public class PxControllerState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxControllerState wrapPointer(long address) {
        return address != 0L ? new PxControllerState(address) : null;
    }
    
    public static PxControllerState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxControllerState(long address) {
        super(address);
    }

    // Constructors

    public PxControllerState() {
        address = _PxControllerState();
    }
    private static native long _PxControllerState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * delta position vector for the object the CCT is standing/riding on. Not always match the CCT delta when variable timesteps are used.
     */
    public PxVec3 getDeltaXP() {
        checkNotNull();
        return PxVec3.wrapPointer(_getDeltaXP(address));
    }
    private static native long _getDeltaXP(long address);

    /**
     * delta position vector for the object the CCT is standing/riding on. Not always match the CCT delta when variable timesteps are used.
     */
    public void setDeltaXP(PxVec3 value) {
        checkNotNull();
        _setDeltaXP(address, value.getAddress());
    }
    private static native void _setDeltaXP(long address, long value);

    /**
     * Shape on which the CCT is standing
     */
    public PxShape getTouchedShape() {
        checkNotNull();
        return PxShape.wrapPointer(_getTouchedShape(address));
    }
    private static native long _getTouchedShape(long address);

    /**
     * Shape on which the CCT is standing
     */
    public void setTouchedShape(PxShape value) {
        checkNotNull();
        _setTouchedShape(address, value.getAddress());
    }
    private static native void _setTouchedShape(long address, long value);

    /**
     * Actor owning 'touchedShape'
     */
    public PxRigidActor getTouchedActor() {
        checkNotNull();
        return PxRigidActor.wrapPointer(_getTouchedActor(address));
    }
    private static native long _getTouchedActor(long address);

    /**
     * Actor owning 'touchedShape'
     */
    public void setTouchedActor(PxRigidActor value) {
        checkNotNull();
        _setTouchedActor(address, value.getAddress());
    }
    private static native void _setTouchedActor(long address, long value);

    /**
     */
    public int getTouchedObstacleHandle() {
        checkNotNull();
        return _getTouchedObstacleHandle(address);
    }
    private static native int _getTouchedObstacleHandle(long address);

    /**
     */
    public void setTouchedObstacleHandle(int value) {
        checkNotNull();
        _setTouchedObstacleHandle(address, value);
    }
    private static native void _setTouchedObstacleHandle(long address, int value);

    /**
     * Last known collision flags (PxControllerCollisionFlag)
     */
    public int getCollisionFlags() {
        checkNotNull();
        return _getCollisionFlags(address);
    }
    private static native int _getCollisionFlags(long address);

    /**
     * Last known collision flags (PxControllerCollisionFlag)
     */
    public void setCollisionFlags(int value) {
        checkNotNull();
        _setCollisionFlags(address, value);
    }
    private static native void _setCollisionFlags(long address, int value);

    /**
     * Are we standing on another CCT?
     */
    public boolean getStandOnAnotherCCT() {
        checkNotNull();
        return _getStandOnAnotherCCT(address);
    }
    private static native boolean _getStandOnAnotherCCT(long address);

    /**
     * Are we standing on another CCT?
     */
    public void setStandOnAnotherCCT(boolean value) {
        checkNotNull();
        _setStandOnAnotherCCT(address, value);
    }
    private static native void _setStandOnAnotherCCT(long address, boolean value);

    /**
     * Are we standing on a user-defined obstacle?
     */
    public boolean getStandOnObstacle() {
        checkNotNull();
        return _getStandOnObstacle(address);
    }
    private static native boolean _getStandOnObstacle(long address);

    /**
     * Are we standing on a user-defined obstacle?
     */
    public void setStandOnObstacle(boolean value) {
        checkNotNull();
        _setStandOnObstacle(address, value);
    }
    private static native void _setStandOnObstacle(long address, boolean value);

    /**
     * is CCT moving up or not? (i.e. explicit jumping)
     */
    public boolean getIsMovingUp() {
        checkNotNull();
        return _getIsMovingUp(address);
    }
    private static native boolean _getIsMovingUp(long address);

    /**
     * is CCT moving up or not? (i.e. explicit jumping)
     */
    public void setIsMovingUp(boolean value) {
        checkNotNull();
        _setIsMovingUp(address, value);
    }
    private static native void _setIsMovingUp(long address, boolean value);

}
