package physx.common;


public class PxErrorCallbackImpl extends PxErrorCallback {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxErrorCallbackImpl wrapPointer(long address) {
        return address != 0L ? new PxErrorCallbackImpl(address) : null;
    }
    
    public static PxErrorCallbackImpl arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxErrorCallbackImpl(long address) {
        super(address);
    }

    protected PxErrorCallbackImpl() {
        address = _PxErrorCallbackImpl();
    }
    private native long _PxErrorCallbackImpl();
    
    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /*
     * Called from native code
     */
    private void _reportError(int code, String message, String file, int line) {
        reportError(PxErrorCodeEnum.forValue(code), message, file, line);
    }

    /**
     * @param code    WebIDL type: {@link PxErrorCodeEnum} [enum]
     * @param message WebIDL type: DOMString [Const]
     * @param file    WebIDL type: DOMString [Const]
     * @param line    WebIDL type: long
     */
    public void reportError(PxErrorCodeEnum code, String message, String file, int line) { }

}
