package physx.cooking;

import physx.NativeObject;

public class PxBVH33MidphaseDesc extends NativeObject {

    protected PxBVH33MidphaseDesc() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxBVH33MidphaseDesc wrapPointer(long address) {
        return address != 0L ? new PxBVH33MidphaseDesc(address) : null;
    }
    
    public static PxBVH33MidphaseDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxBVH33MidphaseDesc(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: float
     */
    public float getMeshSizePerformanceTradeOff() {
        checkNotNull();
        return _getMeshSizePerformanceTradeOff(address);
    }
    private static native float _getMeshSizePerformanceTradeOff(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setMeshSizePerformanceTradeOff(float value) {
        checkNotNull();
        _setMeshSizePerformanceTradeOff(address, value);
    }
    private static native void _setMeshSizePerformanceTradeOff(long address, float value);

    /**
     * @return WebIDL type: {@link PxMeshCookingHintEnum} [enum]
     */
    public PxMeshCookingHintEnum getMeshCookingHint() {
        checkNotNull();
        return PxMeshCookingHintEnum.forValue(_getMeshCookingHint(address));
    }
    private static native int _getMeshCookingHint(long address);

    /**
     * @param value WebIDL type: {@link PxMeshCookingHintEnum} [enum]
     */
    public void setMeshCookingHint(PxMeshCookingHintEnum value) {
        checkNotNull();
        _setMeshCookingHint(address, value.value);
    }
    private static native void _setMeshCookingHint(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
