package physx.extensions;

/**
 * Used to specify the range of motions allowed for a degree of freedom in a D6 joint.
 * <p>
 * <b>See also:</b> PxD6Joint
 */
public enum PxD6MotionEnum {

    /**
     * The DOF is locked, it does not allow relative motion.
     */
    eLOCKED(geteLOCKED()),
    /**
     * The DOF is limited, it only allows motion within a specific range.
     */
    eLIMITED(geteLIMITED()),
    eFREE(geteFREE());
    public final int value;
    
    PxD6MotionEnum(int value) {
        this.value = value;
    }

    private static native int _geteLOCKED();
    private static int geteLOCKED() {
        de.fabmax.physxjni.Loader.load();
        return _geteLOCKED();
    }

    private static native int _geteLIMITED();
    private static int geteLIMITED() {
        de.fabmax.physxjni.Loader.load();
        return _geteLIMITED();
    }

    private static native int _geteFREE();
    private static int geteFREE() {
        de.fabmax.physxjni.Loader.load();
        return _geteFREE();
    }

    public static PxD6MotionEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxD6MotionEnum: " + value);
    }

}
