package physx.extensions;


/**
 * A fixed joint permits no relative movement between two bodies. ie the bodies are glued together.
 * <p>
 * \image html fixedJoint.png
 * @see PxJoint
 */
public class PxFixedJoint extends PxJoint {

    protected PxFixedJoint() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxFixedJoint wrapPointer(long address) {
        return address != 0L ? new PxFixedJoint(address) : null;
    }
    
    public static PxFixedJoint arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxFixedJoint(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

}
