package physx.extensions;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxGjkQueryProximityInfoResult extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxGjkQueryProximityInfoResult wrapPointer(long address) {
        return address != 0L ? new PxGjkQueryProximityInfoResult(address) : null;
    }
    
    public static PxGjkQueryProximityInfoResult arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxGjkQueryProximityInfoResult(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxGjkQueryProximityInfoResult
     */
    public static PxGjkQueryProximityInfoResult createAt(long address) {
        __placement_new_PxGjkQueryProximityInfoResult(address);
        PxGjkQueryProximityInfoResult createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxGjkQueryProximityInfoResult
     */
    public static <T> PxGjkQueryProximityInfoResult createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxGjkQueryProximityInfoResult(address);
        PxGjkQueryProximityInfoResult createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxGjkQueryProximityInfoResult(long address);

    // Constructors

    public PxGjkQueryProximityInfoResult() {
        address = _PxGjkQueryProximityInfoResult();
    }
    private static native long _PxGjkQueryProximityInfoResult();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: boolean
     */
    public boolean getSuccess() {
        checkNotNull();
        return _getSuccess(address);
    }
    private static native boolean _getSuccess(long address);

    /**
     * @param value WebIDL type: boolean
     */
    public void setSuccess(boolean value) {
        checkNotNull();
        _setSuccess(address, value);
    }
    private static native void _setSuccess(long address, boolean value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPointA() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPointA(address));
    }
    private static native long _getPointA(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPointA(PxVec3 value) {
        checkNotNull();
        _setPointA(address, value.getAddress());
    }
    private static native void _setPointA(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getPointB() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPointB(address));
    }
    private static native long _getPointB(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setPointB(PxVec3 value) {
        checkNotNull();
        _setPointB(address, value.getAddress());
    }
    private static native void _setPointB(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getSeparatingAxis() {
        checkNotNull();
        return PxVec3.wrapPointer(_getSeparatingAxis(address));
    }
    private static native long _getSeparatingAxis(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setSeparatingAxis(PxVec3 value) {
        checkNotNull();
        _setSeparatingAxis(address, value.getAddress());
    }
    private static native void _setSeparatingAxis(long address, long value);

    /**
     * @return WebIDL type: float
     */
    public float getSeparation() {
        checkNotNull();
        return _getSeparation(address);
    }
    private static native float _getSeparation(long address);

    /**
     * @param value WebIDL type: float
     */
    public void setSeparation(float value) {
        checkNotNull();
        _setSeparation(address, value);
    }
    private static native void _setSeparation(long address, float value);

}
