package physx.geometry;


/**
 * A class representing the geometry of a sphere.
 * <p>
 * Spheres are defined by their radius.
 * <b>Note:</b> The scaling of the sphere is expected to be baked into this value, there is no additional scaling parameter.
 */
public class PxSphereGeometry extends PxGeometry {

    protected PxSphereGeometry() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSphereGeometry wrapPointer(long address) {
        return address != 0L ? new PxSphereGeometry(address) : null;
    }
    
    public static PxSphereGeometry arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSphereGeometry(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param ir      WebIDL type: float
     * @return Stack allocated object of PxSphereGeometry
     */
    public static PxSphereGeometry createAt(long address, float ir) {
        __placement_new_PxSphereGeometry(address, ir);
        PxSphereGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param ir        WebIDL type: float
     * @return Stack allocated object of PxSphereGeometry
     */
    public static <T> PxSphereGeometry createAt(T allocator, Allocator<T> allocate, float ir) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxSphereGeometry(address, ir);
        PxSphereGeometry createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxSphereGeometry(long address, float ir);

    // Constructors

    /**
     * Constructor.
     */
    public PxSphereGeometry(float ir) {
        address = _PxSphereGeometry(ir);
    }
    private static native long _PxSphereGeometry(float ir);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The radius of the sphere.
     */
    public float getRadius() {
        checkNotNull();
        return _getRadius(address);
    }
    private static native float _getRadius(long address);

    /**
     * The radius of the sphere.
     */
    public void setRadius(float value) {
        checkNotNull();
        _setRadius(address, value);
    }
    private static native void _setRadius(long address, float value);

}
