package physx.physics;

/**
 * Collection of flags providing information on contact report pairs.
 * <p>
 * <b>See also:</b> PxContactPair
 */
public enum PxContactPairFlagEnum {

    /**
     * The shape with index 0 has been removed from the actor/scene.
     */
    eREMOVED_SHAPE_0(geteREMOVED_SHAPE_0()),
    /**
     * The shape with index 1 has been removed from the actor/scene.
     */
    eREMOVED_SHAPE_1(geteREMOVED_SHAPE_1()),
    /**
     * First actor pair contact.
     * <p>
     * The provided shape pair marks the first contact between the two actors, no other shape pair has been touching prior to the current simulation frame.
     * <p>
     * <b>Note:</b>: This info is only available if #PxPairFlag::eNOTIFY_TOUCH_FOUND has been declared for the pair.
     */
    eACTOR_PAIR_HAS_FIRST_TOUCH(geteACTOR_PAIR_HAS_FIRST_TOUCH()),
    /**
     * All contact between the actor pair was lost.
     * <p>
     * All contact between the two actors has been lost, no shape pairs remain touching after the current simulation frame.
     */
    eACTOR_PAIR_LOST_TOUCH(geteACTOR_PAIR_LOST_TOUCH()),
    /**
     * Internal flag, used by #PxContactPair.extractContacts()
     * <p>
     * The applied contact impulses are provided for every contact point. 
     * This is the case if #PxPairFlag::eSOLVE_CONTACT has been set for the pair.
     */
    eINTERNAL_HAS_IMPULSES(geteINTERNAL_HAS_IMPULSES()),
    /**
     * Internal flag, used by #PxContactPair.extractContacts()
     * <p>
     * The provided contact point information is flipped with regards to the shapes of the contact pair. This mainly concerns the order of the internal triangle indices.
     */
    eINTERNAL_CONTACTS_ARE_FLIPPED(geteINTERNAL_CONTACTS_ARE_FLIPPED());
    public final int value;
    
    PxContactPairFlagEnum(int value) {
        this.value = value;
    }

    private static native int _geteREMOVED_SHAPE_0();
    private static int geteREMOVED_SHAPE_0() {
        de.fabmax.physxjni.Loader.load();
        return _geteREMOVED_SHAPE_0();
    }

    private static native int _geteREMOVED_SHAPE_1();
    private static int geteREMOVED_SHAPE_1() {
        de.fabmax.physxjni.Loader.load();
        return _geteREMOVED_SHAPE_1();
    }

    private static native int _geteACTOR_PAIR_HAS_FIRST_TOUCH();
    private static int geteACTOR_PAIR_HAS_FIRST_TOUCH() {
        de.fabmax.physxjni.Loader.load();
        return _geteACTOR_PAIR_HAS_FIRST_TOUCH();
    }

    private static native int _geteACTOR_PAIR_LOST_TOUCH();
    private static int geteACTOR_PAIR_LOST_TOUCH() {
        de.fabmax.physxjni.Loader.load();
        return _geteACTOR_PAIR_LOST_TOUCH();
    }

    private static native int _geteINTERNAL_HAS_IMPULSES();
    private static int geteINTERNAL_HAS_IMPULSES() {
        de.fabmax.physxjni.Loader.load();
        return _geteINTERNAL_HAS_IMPULSES();
    }

    private static native int _geteINTERNAL_CONTACTS_ARE_FLIPPED();
    private static int geteINTERNAL_CONTACTS_ARE_FLIPPED() {
        de.fabmax.physxjni.Loader.load();
        return _geteINTERNAL_CONTACTS_ARE_FLIPPED();
    }

    public static PxContactPairFlagEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxContactPairFlagEnum: " + value);
    }

}
