package physx.physics;

import physx.NativeObject;

/**
 * Class used to retrieve statistics for a simulation step.
 */
public class PxSimulationStatistics extends NativeObject {

    protected PxSimulationStatistics() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxSimulationStatistics wrapPointer(long address) {
        return address != 0L ? new PxSimulationStatistics(address) : null;
    }
    
    public static PxSimulationStatistics arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxSimulationStatistics(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Number of active PxConstraint objects (joints etc.) for the current simulation step.
     */
    public int getNbActiveConstraints() {
        checkNotNull();
        return _getNbActiveConstraints(address);
    }
    private static native int _getNbActiveConstraints(long address);

    /**
     * Number of active PxConstraint objects (joints etc.) for the current simulation step.
     */
    public void setNbActiveConstraints(int value) {
        checkNotNull();
        _setNbActiveConstraints(address, value);
    }
    private static native void _setNbActiveConstraints(long address, int value);

    /**
     * Number of active dynamic bodies for the current simulation step.
     * <p>
     * <b>Note:</b> Does not include active kinematic bodies
     */
    public int getNbActiveDynamicBodies() {
        checkNotNull();
        return _getNbActiveDynamicBodies(address);
    }
    private static native int _getNbActiveDynamicBodies(long address);

    /**
     * Number of active dynamic bodies for the current simulation step.
     * <p>
     * <b>Note:</b> Does not include active kinematic bodies
     */
    public void setNbActiveDynamicBodies(int value) {
        checkNotNull();
        _setNbActiveDynamicBodies(address, value);
    }
    private static native void _setNbActiveDynamicBodies(long address, int value);

    /**
     * Number of active kinematic bodies for the current simulation step.
     * <p>
     * <b>Note:</b> Kinematic deactivation occurs at the end of the frame after the last call to PxRigidDynamic::setKinematicTarget() was called so kinematics that are
     * deactivated in a given frame will be included by this counter.
     */
    public int getNbActiveKinematicBodies() {
        checkNotNull();
        return _getNbActiveKinematicBodies(address);
    }
    private static native int _getNbActiveKinematicBodies(long address);

    /**
     * Number of active kinematic bodies for the current simulation step.
     * <p>
     * <b>Note:</b> Kinematic deactivation occurs at the end of the frame after the last call to PxRigidDynamic::setKinematicTarget() was called so kinematics that are
     * deactivated in a given frame will be included by this counter.
     */
    public void setNbActiveKinematicBodies(int value) {
        checkNotNull();
        _setNbActiveKinematicBodies(address, value);
    }
    private static native void _setNbActiveKinematicBodies(long address, int value);

    /**
     * Number of static bodies for the current simulation step.
     */
    public int getNbStaticBodies() {
        checkNotNull();
        return _getNbStaticBodies(address);
    }
    private static native int _getNbStaticBodies(long address);

    /**
     * Number of static bodies for the current simulation step.
     */
    public void setNbStaticBodies(int value) {
        checkNotNull();
        _setNbStaticBodies(address, value);
    }
    private static native void _setNbStaticBodies(long address, int value);

    /**
     * Number of dynamic bodies for the current simulation step.
     * <p>
     * <b>Note:</b> Includes inactive bodies and articulation links
     * <b>Note:</b> Does not include kinematic bodies
     */
    public int getNbDynamicBodies() {
        checkNotNull();
        return _getNbDynamicBodies(address);
    }
    private static native int _getNbDynamicBodies(long address);

    /**
     * Number of dynamic bodies for the current simulation step.
     * <p>
     * <b>Note:</b> Includes inactive bodies and articulation links
     * <b>Note:</b> Does not include kinematic bodies
     */
    public void setNbDynamicBodies(int value) {
        checkNotNull();
        _setNbDynamicBodies(address, value);
    }
    private static native void _setNbDynamicBodies(long address, int value);

    /**
     * Number of kinematic bodies for the current simulation step.
     * <p>
     * <b>Note:</b> Includes inactive bodies
     */
    public int getNbKinematicBodies() {
        checkNotNull();
        return _getNbKinematicBodies(address);
    }
    private static native int _getNbKinematicBodies(long address);

    /**
     * Number of kinematic bodies for the current simulation step.
     * <p>
     * <b>Note:</b> Includes inactive bodies
     */
    public void setNbKinematicBodies(int value) {
        checkNotNull();
        _setNbKinematicBodies(address, value);
    }
    private static native void _setNbKinematicBodies(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getNbShapes(int index) {
        checkNotNull();
        return _getNbShapes(address, index);
    }
    private static native int _getNbShapes(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setNbShapes(int index, int value) {
        checkNotNull();
        _setNbShapes(address, index, value);
    }
    private static native void _setNbShapes(long address, int index, int value);

    /**
     * Number of aggregates in the scene.
     */
    public int getNbAggregates() {
        checkNotNull();
        return _getNbAggregates(address);
    }
    private static native int _getNbAggregates(long address);

    /**
     * Number of aggregates in the scene.
     */
    public void setNbAggregates(int value) {
        checkNotNull();
        _setNbAggregates(address, value);
    }
    private static native void _setNbAggregates(long address, int value);

    /**
     * Number of articulations in the scene.
     */
    public int getNbArticulations() {
        checkNotNull();
        return _getNbArticulations(address);
    }
    private static native int _getNbArticulations(long address);

    /**
     * Number of articulations in the scene.
     */
    public void setNbArticulations(int value) {
        checkNotNull();
        _setNbArticulations(address, value);
    }
    private static native void _setNbArticulations(long address, int value);

    /**
     * The number of 1D axis constraints(joints+contact) present in the current simulation step.
     */
    public int getNbAxisSolverConstraints() {
        checkNotNull();
        return _getNbAxisSolverConstraints(address);
    }
    private static native int _getNbAxisSolverConstraints(long address);

    /**
     * The number of 1D axis constraints(joints+contact) present in the current simulation step.
     */
    public void setNbAxisSolverConstraints(int value) {
        checkNotNull();
        _setNbAxisSolverConstraints(address, value);
    }
    private static native void _setNbAxisSolverConstraints(long address, int value);

    /**
     * The size (in bytes) of the compressed contact stream in the current simulation step
     */
    public int getCompressedContactSize() {
        checkNotNull();
        return _getCompressedContactSize(address);
    }
    private static native int _getCompressedContactSize(long address);

    /**
     * The size (in bytes) of the compressed contact stream in the current simulation step
     */
    public void setCompressedContactSize(int value) {
        checkNotNull();
        _setCompressedContactSize(address, value);
    }
    private static native void _setCompressedContactSize(long address, int value);

    /**
     * The total required size (in bytes) of the contact constraints in the current simulation step
     */
    public int getRequiredContactConstraintMemory() {
        checkNotNull();
        return _getRequiredContactConstraintMemory(address);
    }
    private static native int _getRequiredContactConstraintMemory(long address);

    /**
     * The total required size (in bytes) of the contact constraints in the current simulation step
     */
    public void setRequiredContactConstraintMemory(int value) {
        checkNotNull();
        _setRequiredContactConstraintMemory(address, value);
    }
    private static native void _setRequiredContactConstraintMemory(long address, int value);

    /**
     * The peak amount of memory (in bytes) that was allocated for constraints (this includes joints) in the current simulation step
     */
    public int getPeakConstraintMemory() {
        checkNotNull();
        return _getPeakConstraintMemory(address);
    }
    private static native int _getPeakConstraintMemory(long address);

    /**
     * The peak amount of memory (in bytes) that was allocated for constraints (this includes joints) in the current simulation step
     */
    public void setPeakConstraintMemory(int value) {
        checkNotNull();
        _setPeakConstraintMemory(address, value);
    }
    private static native void _setPeakConstraintMemory(long address, int value);

    /**
     * Total number of (non CCD) pairs reaching narrow phase
     */
    public int getNbDiscreteContactPairsTotal() {
        checkNotNull();
        return _getNbDiscreteContactPairsTotal(address);
    }
    private static native int _getNbDiscreteContactPairsTotal(long address);

    /**
     * Total number of (non CCD) pairs reaching narrow phase
     */
    public void setNbDiscreteContactPairsTotal(int value) {
        checkNotNull();
        _setNbDiscreteContactPairsTotal(address, value);
    }
    private static native void _setNbDiscreteContactPairsTotal(long address, int value);

    /**
     * Total number of (non CCD) pairs for which contacts are successfully cached (&lt;=nbDiscreteContactPairsTotal)
     * <b>Note:</b> This includes pairs for which no contacts are generated, it still counts as a cache hit.
     */
    public int getNbDiscreteContactPairsWithCacheHits() {
        checkNotNull();
        return _getNbDiscreteContactPairsWithCacheHits(address);
    }
    private static native int _getNbDiscreteContactPairsWithCacheHits(long address);

    /**
     * Total number of (non CCD) pairs for which contacts are successfully cached (&lt;=nbDiscreteContactPairsTotal)
     * <b>Note:</b> This includes pairs for which no contacts are generated, it still counts as a cache hit.
     */
    public void setNbDiscreteContactPairsWithCacheHits(int value) {
        checkNotNull();
        _setNbDiscreteContactPairsWithCacheHits(address, value);
    }
    private static native void _setNbDiscreteContactPairsWithCacheHits(long address, int value);

    /**
     * Total number of (non CCD) pairs for which at least 1 contact was generated (&lt;=nbDiscreteContactPairsTotal)
     */
    public int getNbDiscreteContactPairsWithContacts() {
        checkNotNull();
        return _getNbDiscreteContactPairsWithContacts(address);
    }
    private static native int _getNbDiscreteContactPairsWithContacts(long address);

    /**
     * Total number of (non CCD) pairs for which at least 1 contact was generated (&lt;=nbDiscreteContactPairsTotal)
     */
    public void setNbDiscreteContactPairsWithContacts(int value) {
        checkNotNull();
        _setNbDiscreteContactPairsWithContacts(address, value);
    }
    private static native void _setNbDiscreteContactPairsWithContacts(long address, int value);

    /**
     * Number of new pairs found by BP this frame
     */
    public int getNbNewPairs() {
        checkNotNull();
        return _getNbNewPairs(address);
    }
    private static native int _getNbNewPairs(long address);

    /**
     * Number of new pairs found by BP this frame
     */
    public void setNbNewPairs(int value) {
        checkNotNull();
        _setNbNewPairs(address, value);
    }
    private static native void _setNbNewPairs(long address, int value);

    /**
     * Number of lost pairs from BP this frame
     */
    public int getNbLostPairs() {
        checkNotNull();
        return _getNbLostPairs(address);
    }
    private static native int _getNbLostPairs(long address);

    /**
     * Number of lost pairs from BP this frame
     */
    public void setNbLostPairs(int value) {
        checkNotNull();
        _setNbLostPairs(address, value);
    }
    private static native void _setNbLostPairs(long address, int value);

    /**
     * Number of new touches found by NP this frame
     */
    public int getNbNewTouches() {
        checkNotNull();
        return _getNbNewTouches(address);
    }
    private static native int _getNbNewTouches(long address);

    /**
     * Number of new touches found by NP this frame
     */
    public void setNbNewTouches(int value) {
        checkNotNull();
        _setNbNewTouches(address, value);
    }
    private static native void _setNbNewTouches(long address, int value);

    /**
     * Number of lost touches from NP this frame
     */
    public int getNbLostTouches() {
        checkNotNull();
        return _getNbLostTouches(address);
    }
    private static native int _getNbLostTouches(long address);

    /**
     * Number of lost touches from NP this frame
     */
    public void setNbLostTouches(int value) {
        checkNotNull();
        _setNbLostTouches(address, value);
    }
    private static native void _setNbLostTouches(long address, int value);

    /**
     * Number of partitions used by the solver this frame
     */
    public int getNbPartitions() {
        checkNotNull();
        return _getNbPartitions(address);
    }
    private static native int _getNbPartitions(long address);

    /**
     * Number of partitions used by the solver this frame
     */
    public void setNbPartitions(int value) {
        checkNotNull();
        _setNbPartitions(address, value);
    }
    private static native void _setNbPartitions(long address, int value);

    /**
     */
    public int getNbBroadPhaseAdds() {
        checkNotNull();
        return _getNbBroadPhaseAdds(address);
    }
    private static native int _getNbBroadPhaseAdds(long address);

    /**
     */
    public void setNbBroadPhaseAdds(int value) {
        checkNotNull();
        _setNbBroadPhaseAdds(address, value);
    }
    private static native void _setNbBroadPhaseAdds(long address, int value);

    /**
     */
    public int getNbBroadPhaseRemoves() {
        checkNotNull();
        return _getNbBroadPhaseRemoves(address);
    }
    private static native int _getNbBroadPhaseRemoves(long address);

    /**
     */
    public void setNbBroadPhaseRemoves(int value) {
        checkNotNull();
        _setNbBroadPhaseRemoves(address, value);
    }
    private static native void _setNbBroadPhaseRemoves(long address, int value);

}
