package physx.support;

import physx.NativeObject;
import physx.PlatformChecks;

public class OmniPvdWriter extends NativeObject {

    static {
        PlatformChecks.requirePlatform(7, "physx.support.OmniPvdWriter");
    }

    protected OmniPvdWriter() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static OmniPvdWriter wrapPointer(long address) {
        return address != 0L ? new OmniPvdWriter(address) : null;
    }
    
    public static OmniPvdWriter arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected OmniPvdWriter(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param writeStream WebIDL type: {@link OmniPvdWriteStream} [Ref]
     */
    public void setWriteStream(OmniPvdWriteStream writeStream) {
        checkNotNull();
        _setWriteStream(address, writeStream.getAddress());
    }
    private static native void _setWriteStream(long address, long writeStream);

}
