package physx.vehicle2;

import physx.cooking.PxCookingParams;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;

public class DirectDriveVehicle extends PhysXActorVehicle {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static DirectDriveVehicle wrapPointer(long address) {
        return address != 0L ? new DirectDriveVehicle(address) : null;
    }
    
    public static DirectDriveVehicle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected DirectDriveVehicle(long address) {
        super(address);
    }

    // Constructors

    public DirectDriveVehicle() {
        address = _DirectDriveVehicle();
    }
    private static native long _DirectDriveVehicle();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link DirectDrivetrainParams} [Value]
     */
    public DirectDrivetrainParams getDirectDriveParams() {
        checkNotNull();
        return DirectDrivetrainParams.wrapPointer(_getDirectDriveParams(address));
    }
    private static native long _getDirectDriveParams(long address);

    /**
     * @param value WebIDL type: {@link DirectDrivetrainParams} [Value]
     */
    public void setDirectDriveParams(DirectDrivetrainParams value) {
        checkNotNull();
        _setDirectDriveParams(address, value.getAddress());
    }
    private static native void _setDirectDriveParams(long address, long value);

    /**
     * @return WebIDL type: {@link DirectDrivetrainState} [Value]
     */
    public DirectDrivetrainState getDirectDriveState() {
        checkNotNull();
        return DirectDrivetrainState.wrapPointer(_getDirectDriveState(address));
    }
    private static native long _getDirectDriveState(long address);

    /**
     * @param value WebIDL type: {@link DirectDrivetrainState} [Value]
     */
    public void setDirectDriveState(DirectDrivetrainState value) {
        checkNotNull();
        _setDirectDriveState(address, value.getAddress());
    }
    private static native void _setDirectDriveState(long address, long value);

    /**
     * @return WebIDL type: {@link PxVehicleDirectDriveTransmissionCommandState} [Value]
     */
    public PxVehicleDirectDriveTransmissionCommandState getTransmissionCommandState() {
        checkNotNull();
        return PxVehicleDirectDriveTransmissionCommandState.wrapPointer(_getTransmissionCommandState(address));
    }
    private static native long _getTransmissionCommandState(long address);

    /**
     * @param value WebIDL type: {@link PxVehicleDirectDriveTransmissionCommandState} [Value]
     */
    public void setTransmissionCommandState(PxVehicleDirectDriveTransmissionCommandState value) {
        checkNotNull();
        _setTransmissionCommandState(address, value.getAddress());
    }
    private static native void _setTransmissionCommandState(long address, long value);

    // Functions

    /**
     * @param physics         WebIDL type: {@link PxPhysics} [Ref]
     * @param params          WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param defaultMaterial WebIDL type: {@link PxMaterial} [Ref]
     * @return WebIDL type: boolean
     */
    public boolean initialize(PxPhysics physics, PxCookingParams params, PxMaterial defaultMaterial) {
        checkNotNull();
        return _initialize(address, physics.getAddress(), params.getAddress(), defaultMaterial.getAddress());
    }
    private static native boolean _initialize(long address, long physics, long params, long defaultMaterial);

    /**
     * @param physics                    WebIDL type: {@link PxPhysics} [Ref]
     * @param params                     WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param defaultMaterial            WebIDL type: {@link PxMaterial} [Ref]
     * @param addPhysXBeginEndComponents WebIDL type: boolean
     * @return WebIDL type: boolean
     */
    public boolean initialize(PxPhysics physics, PxCookingParams params, PxMaterial defaultMaterial, boolean addPhysXBeginEndComponents) {
        checkNotNull();
        return _initialize(address, physics.getAddress(), params.getAddress(), defaultMaterial.getAddress(), addPhysXBeginEndComponents);
    }
    private static native boolean _initialize(long address, long physics, long params, long defaultMaterial, boolean addPhysXBeginEndComponents);

    /**
     * @param addPhysXBeginEndComponents WebIDL type: boolean
     */
    public void initComponentSequence(boolean addPhysXBeginEndComponents) {
        checkNotNull();
        _initComponentSequence(address, addPhysXBeginEndComponents);
    }
    private static native void _initComponentSequence(long address, boolean addPhysXBeginEndComponents);

}
