package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleAutoboxState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleAutoboxState wrapPointer(long address) {
        return address != 0L ? new PxVehicleAutoboxState(address) : null;
    }
    
    public static PxVehicleAutoboxState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleAutoboxState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAutoboxState() {
        address = _PxVehicleAutoboxState();
    }
    private static native long _PxVehicleAutoboxState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * Time that has lapsed since the last autobox gear shift.
     * <p>
     * <b>Unit:</b> time
     */
    public float getTimeSinceLastShift() {
        checkNotNull();
        return _getTimeSinceLastShift(address);
    }
    private static native float _getTimeSinceLastShift(long address);

    /**
     * Time that has lapsed since the last autobox gear shift.
     * <p>
     * <b>Unit:</b> time
     */
    public void setTimeSinceLastShift(float value) {
        checkNotNull();
        _setTimeSinceLastShift(address, value);
    }
    private static native void _setTimeSinceLastShift(long address, float value);

    /**
     * Describes whether a gear shift triggered by the autobox is still in flight.
     */
    public boolean getActiveAutoboxGearShift() {
        checkNotNull();
        return _getActiveAutoboxGearShift(address);
    }
    private static native boolean _getActiveAutoboxGearShift(long address);

    /**
     * Describes whether a gear shift triggered by the autobox is still in flight.
     */
    public void setActiveAutoboxGearShift(boolean value) {
        checkNotNull();
        _setActiveAutoboxGearShift(address, value);
    }
    private static native void _setActiveAutoboxGearShift(long address, boolean value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
