package physx.vehicle2;

public enum PxVehicleAxesEnum {

    /**
     * The +x axis
     */
    ePosX(getePosX()),
    /**
     * The -x axis
     */
    eNegX(geteNegX()),
    /**
     * The +y axis
     */
    ePosY(getePosY()),
    /**
     * The -y axis
     */
    eNegY(geteNegY()),
    /**
     * The +z axis
     */
    ePosZ(getePosZ()),
    /**
     * The -z axis
     */
    eNegZ(geteNegZ());
    public final int value;
    
    PxVehicleAxesEnum(int value) {
        this.value = value;
    }

    private static native int _getePosX();
    private static int getePosX() {
        de.fabmax.physxjni.Loader.load();
        return _getePosX();
    }

    private static native int _geteNegX();
    private static int geteNegX() {
        de.fabmax.physxjni.Loader.load();
        return _geteNegX();
    }

    private static native int _getePosY();
    private static int getePosY() {
        de.fabmax.physxjni.Loader.load();
        return _getePosY();
    }

    private static native int _geteNegY();
    private static int geteNegY() {
        de.fabmax.physxjni.Loader.load();
        return _geteNegY();
    }

    private static native int _getePosZ();
    private static int getePosZ() {
        de.fabmax.physxjni.Loader.load();
        return _getePosZ();
    }

    private static native int _geteNegZ();
    private static int geteNegZ() {
        de.fabmax.physxjni.Loader.load();
        return _geteNegZ();
    }

    public static PxVehicleAxesEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehicleAxesEnum: " + value);
    }

}
