package physx.vehicle2;

/**
 * Choose between a potentially more expensive but more accurate solution to the clutch model or a potentially cheaper but less accurate solution.
 * <b>See also:</b> PxVehicleClutchParams
 */
public enum PxVehicleClutchAccuracyModeEnum {

    eESTIMATE(geteESTIMATE()),
    eBEST_POSSIBLE(geteBEST_POSSIBLE());
    public final int value;
    
    PxVehicleClutchAccuracyModeEnum(int value) {
        this.value = value;
    }

    private static native int _geteESTIMATE();
    private static int geteESTIMATE() {
        de.fabmax.physxjni.Loader.load();
        return _geteESTIMATE();
    }

    private static native int _geteBEST_POSSIBLE();
    private static int geteBEST_POSSIBLE() {
        de.fabmax.physxjni.Loader.load();
        return _geteBEST_POSSIBLE();
    }

    public static PxVehicleClutchAccuracyModeEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxVehicleClutchAccuracyModeEnum: " + value);
    }

}
