package physx.vehicle2;

import physx.NativeObject;

/**
 * A mappping between PxMaterial instance and friction for multiple PxMaterial intances.
 */
public class PxVehiclePhysXMaterialFrictionParams extends NativeObject {

    protected PxVehiclePhysXMaterialFrictionParams() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehiclePhysXMaterialFrictionParams wrapPointer(long address) {
        return address != 0L ? new PxVehiclePhysXMaterialFrictionParams(address) : null;
    }
    
    public static PxVehiclePhysXMaterialFrictionParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehiclePhysXMaterialFrictionParams(long address) {
        super(address);
    }

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * An array of mappings between PxMaterial and friction.
     */
    public PxVehiclePhysXMaterialFriction getMaterialFrictions() {
        checkNotNull();
        return PxVehiclePhysXMaterialFriction.wrapPointer(_getMaterialFrictions(address));
    }
    private static native long _getMaterialFrictions(long address);

    /**
     * An array of mappings between PxMaterial and friction.
     */
    public void setMaterialFrictions(PxVehiclePhysXMaterialFriction value) {
        checkNotNull();
        _setMaterialFrictions(address, value.getAddress());
    }
    private static native void _setMaterialFrictions(long address, long value);

    /**
     * The number of mappings between PxMaterial and friction.
     */
    public int getNbMaterialFrictions() {
        checkNotNull();
        return _getNbMaterialFrictions(address);
    }
    private static native int _getNbMaterialFrictions(long address);

    /**
     * The number of mappings between PxMaterial and friction.
     */
    public void setNbMaterialFrictions(int value) {
        checkNotNull();
        _setNbMaterialFrictions(address, value);
    }
    private static native void _setNbMaterialFrictions(long address, int value);

    /**
     * A default friction value to be used in the event that the PxMaterial under the tire is not found in the array #materialFrictions.
     */
    public float getDefaultFriction() {
        checkNotNull();
        return _getDefaultFriction(address);
    }
    private static native float _getDefaultFriction(long address);

    /**
     * A default friction value to be used in the event that the PxMaterial under the tire is not found in the array #materialFrictions.
     */
    public void setDefaultFriction(float value) {
        checkNotNull();
        _setDefaultFriction(address, value);
    }
    private static native void _setDefaultFriction(long address, float value);

    // Functions

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
