package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxVehicleRigidBodyState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleRigidBodyState wrapPointer(long address) {
        return address != 0L ? new PxVehicleRigidBodyState(address) : null;
    }
    
    public static PxVehicleRigidBodyState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleRigidBodyState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleRigidBodyState() {
        address = _PxVehicleRigidBodyState();
    }
    private static native long _PxVehicleRigidBodyState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * the body's pose (in world space)
     */
    public PxTransform getPose() {
        checkNotNull();
        return PxTransform.wrapPointer(_getPose(address));
    }
    private static native long _getPose(long address);

    /**
     * the body's pose (in world space)
     */
    public void setPose(PxTransform value) {
        checkNotNull();
        _setPose(address, value.getAddress());
    }
    private static native void _setPose(long address, long value);

    /**
     * the body's linear velocity (in world space)
     */
    public PxVec3 getLinearVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getLinearVelocity(address));
    }
    private static native long _getLinearVelocity(long address);

    /**
     * the body's linear velocity (in world space)
     */
    public void setLinearVelocity(PxVec3 value) {
        checkNotNull();
        _setLinearVelocity(address, value.getAddress());
    }
    private static native void _setLinearVelocity(long address, long value);

    /**
     * the body's angular velocity (in world space)
     */
    public PxVec3 getAngularVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getAngularVelocity(address));
    }
    private static native long _getAngularVelocity(long address);

    /**
     * the body's angular velocity (in world space)
     */
    public void setAngularVelocity(PxVec3 value) {
        checkNotNull();
        _setAngularVelocity(address, value.getAddress());
    }
    private static native void _setAngularVelocity(long address, long value);

    /**
     * the previous linear velocity of the body (in world space)
     */
    public PxVec3 getPreviousLinearVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPreviousLinearVelocity(address));
    }
    private static native long _getPreviousLinearVelocity(long address);

    /**
     * the previous linear velocity of the body (in world space)
     */
    public void setPreviousLinearVelocity(PxVec3 value) {
        checkNotNull();
        _setPreviousLinearVelocity(address, value.getAddress());
    }
    private static native void _setPreviousLinearVelocity(long address, long value);

    /**
     * the previous angular velocity of the body (in world space)
     */
    public PxVec3 getPreviousAngularVelocity() {
        checkNotNull();
        return PxVec3.wrapPointer(_getPreviousAngularVelocity(address));
    }
    private static native long _getPreviousAngularVelocity(long address);

    /**
     * the previous angular velocity of the body (in world space)
     */
    public void setPreviousAngularVelocity(PxVec3 value) {
        checkNotNull();
        _setPreviousAngularVelocity(address, value.getAddress());
    }
    private static native void _setPreviousAngularVelocity(long address, long value);

    /**
     * external force (in world space) affecting the rigid body (usually excluding gravitational force)
     */
    public PxVec3 getExternalForce() {
        checkNotNull();
        return PxVec3.wrapPointer(_getExternalForce(address));
    }
    private static native long _getExternalForce(long address);

    /**
     * external force (in world space) affecting the rigid body (usually excluding gravitational force)
     */
    public void setExternalForce(PxVec3 value) {
        checkNotNull();
        _setExternalForce(address, value.getAddress());
    }
    private static native void _setExternalForce(long address, long value);

    /**
     * external torque (in world space) affecting the rigid body
     */
    public PxVec3 getExternalTorque() {
        checkNotNull();
        return PxVec3.wrapPointer(_getExternalTorque(address));
    }
    private static native long _getExternalTorque(long address);

    /**
     * external torque (in world space) affecting the rigid body
     */
    public void setExternalTorque(PxVec3 value) {
        checkNotNull();
        _setExternalTorque(address, value.getAddress());
    }
    private static native void _setExternalTorque(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * Compute the vertical speed of the rigid body transformed to the world frame.
     * @param frame describes the axes of the vehicle
     */
    public float getVerticalSpeed(PxVehicleFrame frame) {
        checkNotNull();
        return _getVerticalSpeed(address, frame.getAddress());
    }
    private static native float _getVerticalSpeed(long address, long frame);

    /**
     * @param frame describes the axes of the vehicle
     * Compute the lateral speed of the rigid body transformed to the world frame.
     */
    public float getLateralSpeed(PxVehicleFrame frame) {
        checkNotNull();
        return _getLateralSpeed(address, frame.getAddress());
    }
    private static native float _getLateralSpeed(long address, long frame);

    /**
     * Compute the longitudinal speed of the rigid body transformed to the world frame.
     * @param frame describes the axes of the vehicle
     */
    public float getLongitudinalSpeed(PxVehicleFrame frame) {
        checkNotNull();
        return _getLongitudinalSpeed(address, frame.getAddress());
    }
    private static native float _getLongitudinalSpeed(long address, long frame);

}
