package physx.vehicle2;

import physx.NativeObject;

/**
 * Compliance describes how toe and camber angle and force application points are affected by suspension compression.
 * <b>Note:</b> Each compliance term is in the form of a graph with up to 3 points. 
 * <b>Note:</b> Each point in the graph has form (jounce/suspensionTravelDist, complianceValue).
 * <b>Note:</b> The sequence of points must respresent monotonically increasing values of jounce.
 * <b>Note:</b> The compliance value can be computed by linear interpolation.
 * <b>Note:</b> If any graph has zero points in it, a value of 0.0 is used for the compliance value. 
 * <b>Note:</b> If any graph has 1 point in it, the compliance value of that point is used directly. 
 */
public class PxVehicleSuspensionComplianceParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionComplianceParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionComplianceParams(address) : null;
    }
    
    public static PxVehicleSuspensionComplianceParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionComplianceParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionComplianceParams() {
        address = _PxVehicleSuspensionComplianceParams();
    }
    private static native long _PxVehicleSuspensionComplianceParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * A graph of toe angle against jounce/suspensionTravelDist with the toe angle expressed in radians.
     * <b>Note:</b> The toe angle is applied in the suspension frame.
     */
    public PxVehicleFixedSizeLookupTableFloat_3 getWheelToeAngle() {
        checkNotNull();
        return PxVehicleFixedSizeLookupTableFloat_3.wrapPointer(_getWheelToeAngle(address));
    }
    private static native long _getWheelToeAngle(long address);

    /**
     * A graph of toe angle against jounce/suspensionTravelDist with the toe angle expressed in radians.
     * <b>Note:</b> The toe angle is applied in the suspension frame.
     */
    public void setWheelToeAngle(PxVehicleFixedSizeLookupTableFloat_3 value) {
        checkNotNull();
        _setWheelToeAngle(address, value.getAddress());
    }
    private static native void _setWheelToeAngle(long address, long value);

    /**
     * A graph of camber angle against jounce/suspensionTravelDist with the camber angle expressed in radians.
     * <b>Note:</b> The camber angle is applied in the suspension frame.
     */
    public PxVehicleFixedSizeLookupTableFloat_3 getWheelCamberAngle() {
        checkNotNull();
        return PxVehicleFixedSizeLookupTableFloat_3.wrapPointer(_getWheelCamberAngle(address));
    }
    private static native long _getWheelCamberAngle(long address);

    /**
     * A graph of camber angle against jounce/suspensionTravelDist with the camber angle expressed in radians.
     * <b>Note:</b> The camber angle is applied in the suspension frame.
     */
    public void setWheelCamberAngle(PxVehicleFixedSizeLookupTableFloat_3 value) {
        checkNotNull();
        _setWheelCamberAngle(address, value.getAddress());
    }
    private static native void _setWheelCamberAngle(long address, long value);

    /**
     * Suspension forces are applied at an offset from the suspension frame. suspForceAppPoint
     * specifies the (X, Y, Z) components of that offset as a function of jounce/suspensionTravelDist.
     */
    public PxVehicleFixedSizeLookupTableVec3_3 getSuspForceAppPoint() {
        checkNotNull();
        return PxVehicleFixedSizeLookupTableVec3_3.wrapPointer(_getSuspForceAppPoint(address));
    }
    private static native long _getSuspForceAppPoint(long address);

    /**
     * Suspension forces are applied at an offset from the suspension frame. suspForceAppPoint
     * specifies the (X, Y, Z) components of that offset as a function of jounce/suspensionTravelDist.
     */
    public void setSuspForceAppPoint(PxVehicleFixedSizeLookupTableVec3_3 value) {
        checkNotNull();
        _setSuspForceAppPoint(address, value.getAddress());
    }
    private static native void _setSuspForceAppPoint(long address, long value);

    /**
     * Tire forces are applied at an offset from the suspension frame. tireForceAppPoint
     * specifies the (X, Y, Z) components of that offset as a function of jounce/suspensionTravelDist.
     */
    public PxVehicleFixedSizeLookupTableVec3_3 getTireForceAppPoint() {
        checkNotNull();
        return PxVehicleFixedSizeLookupTableVec3_3.wrapPointer(_getTireForceAppPoint(address));
    }
    private static native long _getTireForceAppPoint(long address);

    /**
     * Tire forces are applied at an offset from the suspension frame. tireForceAppPoint
     * specifies the (X, Y, Z) components of that offset as a function of jounce/suspensionTravelDist.
     */
    public void setTireForceAppPoint(PxVehicleFixedSizeLookupTableVec3_3 value) {
        checkNotNull();
        _setTireForceAppPoint(address, value.getAddress());
    }
    private static native void _setTireForceAppPoint(long address, long value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleSuspensionComplianceParams} [Value]
     */
    public PxVehicleSuspensionComplianceParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleSuspensionComplianceParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
