package physx.vehicle2;

import physx.NativeObject;

/**
 * Camber angle of the tire relative to the ground plane.
 */
public class PxVehicleTireCamberAngleState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireCamberAngleState wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireCamberAngleState(address) : null;
    }
    
    public static PxVehicleTireCamberAngleState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireCamberAngleState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleTireCamberAngleState() {
        address = _PxVehicleTireCamberAngleState();
    }
    private static native long _PxVehicleTireCamberAngleState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public float getCamberAngle() {
        checkNotNull();
        return _getCamberAngle(address);
    }
    private static native float _getCamberAngle(long address);

    /**
     */
    public void setCamberAngle(float value) {
        checkNotNull();
        _setCamberAngle(address, value);
    }
    private static native void _setCamberAngle(long address, float value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
