package physx.vehicle2;

import physx.NativeObject;

/**
 * Specify groups of wheels that are to be constrained to have pre-determined angular velocity relationship.
 */
public class PxVehicleWheelConstraintGroupState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleWheelConstraintGroupState wrapPointer(long address) {
        return address != 0L ? new PxVehicleWheelConstraintGroupState(address) : null;
    }
    
    public static PxVehicleWheelConstraintGroupState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleWheelConstraintGroupState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleWheelConstraintGroupState() {
        address = _PxVehicleWheelConstraintGroupState();
    }
    private static native long _PxVehicleWheelConstraintGroupState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The number of constraint groups in the vehicle
     */
    public int getNbGroups() {
        checkNotNull();
        return _getNbGroups(address);
    }
    private static native int _getNbGroups(long address);

    /**
     * The number of constraint groups in the vehicle
     */
    public void setNbGroups(int value) {
        checkNotNull();
        _setNbGroups(address, value);
    }
    private static native void _setNbGroups(long address, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getNbWheelsPerGroup(int index) {
        checkNotNull();
        return _getNbWheelsPerGroup(address, index);
    }
    private static native int _getNbWheelsPerGroup(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setNbWheelsPerGroup(int index, int value) {
        checkNotNull();
        _setNbWheelsPerGroup(address, index, value);
    }
    private static native void _setNbWheelsPerGroup(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getGroupToWheelIds(int index) {
        checkNotNull();
        return _getGroupToWheelIds(address, index);
    }
    private static native int _getGroupToWheelIds(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setGroupToWheelIds(int index, int value) {
        checkNotNull();
        _setGroupToWheelIds(address, index, value);
    }
    private static native void _setGroupToWheelIds(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: unsigned long
     */
    public int getWheelIdsInGroupOrder(int index) {
        checkNotNull();
        return _getWheelIdsInGroupOrder(address, index);
    }
    private static native int _getWheelIdsInGroupOrder(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: unsigned long
     */
    public void setWheelIdsInGroupOrder(int index, int value) {
        checkNotNull();
        _setWheelIdsInGroupOrder(address, index, value);
    }
    private static native void _setWheelIdsInGroupOrder(long address, int index, int value);

    /**
     * @param index Array index
     * @return WebIDL type: float
     */
    public float getWheelMultipliersInGroupOrder(int index) {
        checkNotNull();
        return _getWheelMultipliersInGroupOrder(address, index);
    }
    private static native float _getWheelMultipliersInGroupOrder(long address, int index);

    /**
     * @param index Array index
     * @param value WebIDL type: float
     */
    public void setWheelMultipliersInGroupOrder(int index, float value) {
        checkNotNull();
        _setWheelMultipliersInGroupOrder(address, index, value);
    }
    private static native void _setWheelMultipliersInGroupOrder(long address, int index, float value);

    /**
     * The number of wheels in a constraint group.
     */
    public int getNbWheelsInGroups() {
        checkNotNull();
        return _getNbWheelsInGroups(address);
    }
    private static native int _getNbWheelsInGroups(long address);

    /**
     * The number of wheels in a constraint group.
     */
    public void setNbWheelsInGroups(int value) {
        checkNotNull();
        _setNbWheelsInGroups(address, value);
    }
    private static native void _setNbWheelsInGroups(long address, int value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

    /**
     * Return the number of wheel constraint groups in the vehicle.
     * @return The number of wheel constraint groups.
     * @see #getNbWheelsInConstraintGroup
     */
    public int getNbConstraintGroups() {
        checkNotNull();
        return _getNbConstraintGroups(address);
    }
    private static native int _getNbConstraintGroups(long address);

    /**
     * Return the number of wheels in the ith constraint group.
     * @param i specifies the constraint group to be queried for its wheel count.
     * @return The number of wheels in the specified constraint group.
     * @see #getWheelInConstraintGroup
     */
    public int getNbWheelsInConstraintGroup(int i) {
        checkNotNull();
        return _getNbWheelsInConstraintGroup(address, i);
    }
    private static native int _getNbWheelsInConstraintGroup(long address, int i);

    /**
     * Return the wheel id of the jth wheel in the ith constraint group.
     * @param j specifies that the wheel id to be returned is the jth wheel in the list of wheels on the specified constraint group.
     * @param i specifies the constraint group to be queried.
     * @return The wheel id of the jth wheel in the ith constraint group.
     * @see #getNbWheelsInConstraintGroup
     */
    public int getWheelInConstraintGroup(int j, int i) {
        checkNotNull();
        return _getWheelInConstraintGroup(address, j, i);
    }
    private static native int _getWheelInConstraintGroup(long address, int j, int i);

    /**
     * Return the constraint multiplier of the jth wheel in the ith constraint group
     * @param j specifies that the wheel id to be returned is the jth wheel in the list of wheels on the specified constraint group.
     * @param i specifies the constraint group to be queried.
     * @return The constraint multiplier of the jth wheel in the ith constraint group.
     */
    public float getMultiplierInConstraintGroup(int j, int i) {
        checkNotNull();
        return _getMultiplierInConstraintGroup(address, j, i);
    }
    private static native float _getMultiplierInConstraintGroup(long address, int j, int i);

}
