package physx;

import physx.character.PxControllerManager;
import physx.common.PxDefaultAllocator;
import physx.common.PxDefaultCpuDispatcher;
import physx.common.PxErrorCallback;
import physx.common.PxFoundation;
import physx.common.PxOutputStream;
import physx.common.PxPlane;
import physx.common.PxTolerancesScale;
import physx.common.PxTransform;
import physx.common.PxVec3;
import physx.cooking.PxConvexMeshDesc;
import physx.cooking.PxCookingParams;
import physx.cooking.PxTriangleMeshDesc;
import physx.extensions.PxD6Joint;
import physx.extensions.PxDistanceJoint;
import physx.extensions.PxFixedJoint;
import physx.extensions.PxGearJoint;
import physx.extensions.PxPrismaticJoint;
import physx.extensions.PxRackAndPinionJoint;
import physx.extensions.PxRevoluteJoint;
import physx.extensions.PxSphericalJoint;
import physx.geometry.PxConvexMesh;
import physx.geometry.PxGeometry;
import physx.geometry.PxHeightField;
import physx.geometry.PxHeightFieldDesc;
import physx.geometry.PxTriangleMesh;
import physx.physics.PxMaterial;
import physx.physics.PxPhysics;
import physx.physics.PxRigidActor;
import physx.physics.PxRigidDynamic;
import physx.physics.PxRigidStatic;
import physx.physics.PxScene;
import physx.physics.PxSceneDesc;
import physx.physics.PxShape;
import physx.physics.PxSimulationFilterShader;
import physx.support.PassThroughFilterShader;
import physx.support.PxOmniPvd;
import physx.support.PxPvd;
import physx.support.PxPvdTransport;

public class PxTopLevelFunctions extends NativeObject {

    protected PxTopLevelFunctions() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTopLevelFunctions wrapPointer(long address) {
        return address != 0L ? new PxTopLevelFunctions(address) : null;
    }
    
    public static PxTopLevelFunctions arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTopLevelFunctions(long address) {
        super(address);
    }

    // Attributes

    /**
     * @return WebIDL type: unsigned long
     */
    public static int getPHYSICS_VERSION() {
        return _getPHYSICS_VERSION();
    }
    private static native int _getPHYSICS_VERSION();

    // Functions

    /**
     * @return WebIDL type: {@link PxSimulationFilterShader} [Value]
     */
    public static PxSimulationFilterShader DefaultFilterShader() {
        return PxSimulationFilterShader.wrapPointer(_DefaultFilterShader());
    }
    private static native long _DefaultFilterShader();

    /**
     * @param sceneDesc    WebIDL type: {@link PxSceneDesc}
     * @param filterShader WebIDL type: {@link PassThroughFilterShader}
     */
    public static void setupPassThroughFilterShader(PxSceneDesc sceneDesc, PassThroughFilterShader filterShader) {
        _setupPassThroughFilterShader(sceneDesc.getAddress(), filterShader.getAddress());
    }
    private static native void _setupPassThroughFilterShader(long sceneDesc, long filterShader);

    /**
     * @param scene WebIDL type: {@link PxScene} [Ref]
     * @return WebIDL type: {@link PxControllerManager}
     */
    public static PxControllerManager CreateControllerManager(PxScene scene) {
        return PxControllerManager.wrapPointer(_CreateControllerManager(scene.getAddress()));
    }
    private static native long _CreateControllerManager(long scene);

    /**
     * @param scene          WebIDL type: {@link PxScene} [Ref]
     * @param lockingEnabled WebIDL type: boolean
     * @return WebIDL type: {@link PxControllerManager}
     */
    public static PxControllerManager CreateControllerManager(PxScene scene, boolean lockingEnabled) {
        return PxControllerManager.wrapPointer(_CreateControllerManager(scene.getAddress(), lockingEnabled));
    }
    private static native long _CreateControllerManager(long scene, boolean lockingEnabled);

    /**
     * @param version       WebIDL type: unsigned long
     * @param allocator     WebIDL type: {@link PxDefaultAllocator} [Ref]
     * @param errorCallback WebIDL type: {@link PxErrorCallback} [Ref]
     * @return WebIDL type: {@link PxFoundation}
     */
    public static PxFoundation CreateFoundation(int version, PxDefaultAllocator allocator, PxErrorCallback errorCallback) {
        return PxFoundation.wrapPointer(_CreateFoundation(version, allocator.getAddress(), errorCallback.getAddress()));
    }
    private static native long _CreateFoundation(int version, long allocator, long errorCallback);

    /**
     * @param version    WebIDL type: unsigned long
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param params     WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @return WebIDL type: {@link PxPhysics}
     */
    public static PxPhysics CreatePhysics(int version, PxFoundation foundation, PxTolerancesScale params) {
        return PxPhysics.wrapPointer(_CreatePhysics(version, foundation.getAddress(), params.getAddress()));
    }
    private static native long _CreatePhysics(int version, long foundation, long params);

    /**
     * @param version    WebIDL type: unsigned long
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param params     WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @param pvd        WebIDL type: {@link PxPvd} [Nullable]
     * @return WebIDL type: {@link PxPhysics}
     */
    public static PxPhysics CreatePhysics(int version, PxFoundation foundation, PxTolerancesScale params, PxPvd pvd) {
        return PxPhysics.wrapPointer(_CreatePhysics(version, foundation.getAddress(), params.getAddress(), (pvd != null ? pvd.getAddress() : 0L)));
    }
    private static native long _CreatePhysics(int version, long foundation, long params, long pvd);

    /**
     * @param version    WebIDL type: unsigned long
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @param params     WebIDL type: {@link PxTolerancesScale} [Const, Ref]
     * @param pvd        WebIDL type: {@link PxPvd} [Nullable]
     * @param omniPvd    WebIDL type: {@link PxOmniPvd} [Nullable]
     * @return WebIDL type: {@link PxPhysics}
     */
    public static PxPhysics CreatePhysics(int version, PxFoundation foundation, PxTolerancesScale params, PxPvd pvd, PxOmniPvd omniPvd) {
        return PxPhysics.wrapPointer(_CreatePhysics(version, foundation.getAddress(), params.getAddress(), (pvd != null ? pvd.getAddress() : 0L), (omniPvd != null ? omniPvd.getAddress() : 0L)));
    }
    private static native long _CreatePhysics(int version, long foundation, long params, long pvd, long omniPvd);

    /**
     * @param numThreads WebIDL type: unsigned long
     * @return WebIDL type: {@link PxDefaultCpuDispatcher}
     */
    public static PxDefaultCpuDispatcher DefaultCpuDispatcherCreate(int numThreads) {
        return PxDefaultCpuDispatcher.wrapPointer(_DefaultCpuDispatcherCreate(numThreads));
    }
    private static native long _DefaultCpuDispatcherCreate(int numThreads);

    /**
     * @param physics WebIDL type: {@link PxPhysics} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean InitExtensions(PxPhysics physics) {
        return _InitExtensions(physics.getAddress());
    }
    private static native boolean _InitExtensions(long physics);

    public static void CloseExtensions() {
        _CloseExtensions();
    }
    private static native void _CloseExtensions();

    /**
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @return WebIDL type: {@link PxPvd}
     */
    public static PxPvd CreatePvd(PxFoundation foundation) {
        return PxPvd.wrapPointer(_CreatePvd(foundation.getAddress()));
    }
    private static native long _CreatePvd(long foundation);

    /**
     * @param host                  WebIDL type: DOMString
     * @param port                  WebIDL type: long
     * @param timeoutInMilliseconds WebIDL type: unsigned long
     * @return WebIDL type: {@link PxPvdTransport} [Platforms=windows;linux;macos]
     */
    public static PxPvdTransport DefaultPvdSocketTransportCreate(String host, int port, int timeoutInMilliseconds) {
        PlatformChecks.requirePlatform(7, "physx.PxTopLevelFunctions");
        return PxPvdTransport.wrapPointer(_DefaultPvdSocketTransportCreate(host, port, timeoutInMilliseconds));
    }
    private static native long _DefaultPvdSocketTransportCreate(String host, int port, int timeoutInMilliseconds);

    /**
     * @param foundation WebIDL type: {@link PxFoundation} [Ref]
     * @return WebIDL type: {@link PxOmniPvd} [Platforms=windows;linux;macos]
     */
    public static PxOmniPvd CreateOmniPvd(PxFoundation foundation) {
        PlatformChecks.requirePlatform(7, "physx.PxTopLevelFunctions");
        return PxOmniPvd.wrapPointer(_CreateOmniPvd(foundation.getAddress()));
    }
    private static native long _CreateOmniPvd(long foundation);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxD6Joint}
     */
    public static PxD6Joint D6JointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxD6Joint.wrapPointer(_D6JointCreate(physics.getAddress(), (actor0 != null ? actor0.getAddress() : 0L), localFrame0.getAddress(), (actor1 != null ? actor1.getAddress() : 0L), localFrame1.getAddress()));
    }
    private static native long _D6JointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxDistanceJoint}
     */
    public static PxDistanceJoint DistanceJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxDistanceJoint.wrapPointer(_DistanceJointCreate(physics.getAddress(), (actor0 != null ? actor0.getAddress() : 0L), localFrame0.getAddress(), (actor1 != null ? actor1.getAddress() : 0L), localFrame1.getAddress()));
    }
    private static native long _DistanceJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxFixedJoint}
     */
    public static PxFixedJoint FixedJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxFixedJoint.wrapPointer(_FixedJointCreate(physics.getAddress(), (actor0 != null ? actor0.getAddress() : 0L), localFrame0.getAddress(), (actor1 != null ? actor1.getAddress() : 0L), localFrame1.getAddress()));
    }
    private static native long _FixedJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor}
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor}
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxGearJoint}
     */
    public static PxGearJoint GearJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxGearJoint.wrapPointer(_GearJointCreate(physics.getAddress(), actor0.getAddress(), localFrame0.getAddress(), actor1.getAddress(), localFrame1.getAddress()));
    }
    private static native long _GearJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxPrismaticJoint}
     */
    public static PxPrismaticJoint PrismaticJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxPrismaticJoint.wrapPointer(_PrismaticJointCreate(physics.getAddress(), (actor0 != null ? actor0.getAddress() : 0L), localFrame0.getAddress(), (actor1 != null ? actor1.getAddress() : 0L), localFrame1.getAddress()));
    }
    private static native long _PrismaticJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor}
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor}
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxRackAndPinionJoint}
     */
    public static PxRackAndPinionJoint RackAndPinionJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxRackAndPinionJoint.wrapPointer(_RackAndPinionJointCreate(physics.getAddress(), actor0.getAddress(), localFrame0.getAddress(), actor1.getAddress(), localFrame1.getAddress()));
    }
    private static native long _RackAndPinionJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxRevoluteJoint}
     */
    public static PxRevoluteJoint RevoluteJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxRevoluteJoint.wrapPointer(_RevoluteJointCreate(physics.getAddress(), (actor0 != null ? actor0.getAddress() : 0L), localFrame0.getAddress(), (actor1 != null ? actor1.getAddress() : 0L), localFrame1.getAddress()));
    }
    private static native long _RevoluteJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param actor0      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame0 WebIDL type: {@link PxTransform} [Ref]
     * @param actor1      WebIDL type: {@link PxRigidActor} [Nullable]
     * @param localFrame1 WebIDL type: {@link PxTransform} [Ref]
     * @return WebIDL type: {@link PxSphericalJoint}
     */
    public static PxSphericalJoint SphericalJointCreate(PxPhysics physics, PxRigidActor actor0, PxTransform localFrame0, PxRigidActor actor1, PxTransform localFrame1) {
        return PxSphericalJoint.wrapPointer(_SphericalJointCreate(physics.getAddress(), (actor0 != null ? actor0.getAddress() : 0L), localFrame0.getAddress(), (actor1 != null ? actor1.getAddress() : 0L), localFrame1.getAddress()));
    }
    private static native long _SphericalJointCreate(long physics, long actor0, long localFrame0, long actor1, long localFrame1);

    /**
     * @param params WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param desc   WebIDL type: {@link PxConvexMeshDesc} [Const, Ref]
     * @return WebIDL type: {@link PxConvexMesh}
     */
    public static PxConvexMesh CreateConvexMesh(PxCookingParams params, PxConvexMeshDesc desc) {
        return PxConvexMesh.wrapPointer(_CreateConvexMesh(params.getAddress(), desc.getAddress()));
    }
    private static native long _CreateConvexMesh(long params, long desc);

    /**
     * @param params WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param desc   WebIDL type: {@link PxTriangleMeshDesc} [Const, Ref]
     * @return WebIDL type: {@link PxTriangleMesh}
     */
    public static PxTriangleMesh CreateTriangleMesh(PxCookingParams params, PxTriangleMeshDesc desc) {
        return PxTriangleMesh.wrapPointer(_CreateTriangleMesh(params.getAddress(), desc.getAddress()));
    }
    private static native long _CreateTriangleMesh(long params, long desc);

    /**
     * @param desc WebIDL type: {@link PxHeightFieldDesc} [Const, Ref]
     * @return WebIDL type: {@link PxHeightField}
     */
    public static PxHeightField CreateHeightField(PxHeightFieldDesc desc) {
        return PxHeightField.wrapPointer(_CreateHeightField(desc.getAddress()));
    }
    private static native long _CreateHeightField(long desc);

    /**
     * @param params WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param desc   WebIDL type: {@link PxTriangleMeshDesc} [Const, Ref]
     * @param stream WebIDL type: {@link PxOutputStream} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean CookTriangleMesh(PxCookingParams params, PxTriangleMeshDesc desc, PxOutputStream stream) {
        return _CookTriangleMesh(params.getAddress(), desc.getAddress(), stream.getAddress());
    }
    private static native boolean _CookTriangleMesh(long params, long desc, long stream);

    /**
     * @param params WebIDL type: {@link PxCookingParams} [Const, Ref]
     * @param desc   WebIDL type: {@link PxConvexMeshDesc} [Const, Ref]
     * @param stream WebIDL type: {@link PxOutputStream} [Ref]
     * @return WebIDL type: boolean
     */
    public static boolean CookConvexMesh(PxCookingParams params, PxConvexMeshDesc desc, PxOutputStream stream) {
        return _CookConvexMesh(params.getAddress(), desc.getAddress(), stream.getAddress());
    }
    private static native boolean _CookConvexMesh(long params, long desc, long stream);

    /**
     * @param sdk       WebIDL type: {@link PxPhysics} [Ref]
     * @param transform WebIDL type: {@link PxTransform} [Const, Ref]
     * @param shape     WebIDL type: {@link PxShape} [Ref]
     * @param density   WebIDL type: float
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public static PxRigidDynamic CreateDynamicFromShape(PxPhysics sdk, PxTransform transform, PxShape shape, float density) {
        return PxRigidDynamic.wrapPointer(_CreateDynamicFromShape(sdk.getAddress(), transform.getAddress(), shape.getAddress(), density));
    }
    private static native long _CreateDynamicFromShape(long sdk, long transform, long shape, float density);

    /**
     * @param sdk       WebIDL type: {@link PxPhysics} [Ref]
     * @param transform WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geometry  WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material  WebIDL type: {@link PxMaterial} [Ref]
     * @param density   WebIDL type: float
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public static PxRigidDynamic CreateDynamic(PxPhysics sdk, PxTransform transform, PxGeometry geometry, PxMaterial material, float density) {
        return PxRigidDynamic.wrapPointer(_CreateDynamic(sdk.getAddress(), transform.getAddress(), geometry.getAddress(), material.getAddress(), density));
    }
    private static native long _CreateDynamic(long sdk, long transform, long geometry, long material, float density);

    /**
     * @param sdk         WebIDL type: {@link PxPhysics} [Ref]
     * @param transform   WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geometry    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material    WebIDL type: {@link PxMaterial} [Ref]
     * @param density     WebIDL type: float
     * @param shapeOffset WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public static PxRigidDynamic CreateDynamic(PxPhysics sdk, PxTransform transform, PxGeometry geometry, PxMaterial material, float density, PxTransform shapeOffset) {
        return PxRigidDynamic.wrapPointer(_CreateDynamic(sdk.getAddress(), transform.getAddress(), geometry.getAddress(), material.getAddress(), density, shapeOffset.getAddress()));
    }
    private static native long _CreateDynamic(long sdk, long transform, long geometry, long material, float density, long shapeOffset);

    /**
     * @param sdk       WebIDL type: {@link PxPhysics} [Ref]
     * @param transform WebIDL type: {@link PxTransform} [Const, Ref]
     * @param shape     WebIDL type: {@link PxShape} [Ref]
     * @param density   WebIDL type: float
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public static PxRigidDynamic CreateKinematicFromShape(PxPhysics sdk, PxTransform transform, PxShape shape, float density) {
        return PxRigidDynamic.wrapPointer(_CreateKinematicFromShape(sdk.getAddress(), transform.getAddress(), shape.getAddress(), density));
    }
    private static native long _CreateKinematicFromShape(long sdk, long transform, long shape, float density);

    /**
     * @param sdk       WebIDL type: {@link PxPhysics} [Ref]
     * @param transform WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geometry  WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material  WebIDL type: {@link PxMaterial} [Ref]
     * @param density   WebIDL type: float
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public static PxRigidDynamic CreateKinematic(PxPhysics sdk, PxTransform transform, PxGeometry geometry, PxMaterial material, float density) {
        return PxRigidDynamic.wrapPointer(_CreateKinematic(sdk.getAddress(), transform.getAddress(), geometry.getAddress(), material.getAddress(), density));
    }
    private static native long _CreateKinematic(long sdk, long transform, long geometry, long material, float density);

    /**
     * @param sdk         WebIDL type: {@link PxPhysics} [Ref]
     * @param transform   WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geometry    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material    WebIDL type: {@link PxMaterial} [Ref]
     * @param density     WebIDL type: float
     * @param shapeOffset WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public static PxRigidDynamic CreateKinematic(PxPhysics sdk, PxTransform transform, PxGeometry geometry, PxMaterial material, float density, PxTransform shapeOffset) {
        return PxRigidDynamic.wrapPointer(_CreateKinematic(sdk.getAddress(), transform.getAddress(), geometry.getAddress(), material.getAddress(), density, shapeOffset.getAddress()));
    }
    private static native long _CreateKinematic(long sdk, long transform, long geometry, long material, float density, long shapeOffset);

    /**
     * @param sdk       WebIDL type: {@link PxPhysics} [Ref]
     * @param transform WebIDL type: {@link PxTransform} [Const, Ref]
     * @param shape     WebIDL type: {@link PxShape} [Ref]
     * @return WebIDL type: {@link PxRigidStatic}
     */
    public static PxRigidStatic CreateStaticFromShape(PxPhysics sdk, PxTransform transform, PxShape shape) {
        return PxRigidStatic.wrapPointer(_CreateStaticFromShape(sdk.getAddress(), transform.getAddress(), shape.getAddress()));
    }
    private static native long _CreateStaticFromShape(long sdk, long transform, long shape);

    /**
     * @param sdk         WebIDL type: {@link PxPhysics} [Ref]
     * @param transform   WebIDL type: {@link PxTransform} [Const, Ref]
     * @param geometry    WebIDL type: {@link PxGeometry} [Const, Ref]
     * @param material    WebIDL type: {@link PxMaterial} [Ref]
     * @param shapeOffset WebIDL type: {@link PxTransform} [Const, Ref]
     * @return WebIDL type: {@link PxRigidStatic}
     */
    public static PxRigidStatic CreateStatic(PxPhysics sdk, PxTransform transform, PxGeometry geometry, PxMaterial material, PxTransform shapeOffset) {
        return PxRigidStatic.wrapPointer(_CreateStatic(sdk.getAddress(), transform.getAddress(), geometry.getAddress(), material.getAddress(), shapeOffset.getAddress()));
    }
    private static native long _CreateStatic(long sdk, long transform, long geometry, long material, long shapeOffset);

    /**
     * @param sdk      WebIDL type: {@link PxPhysics} [Ref]
     * @param plane    WebIDL type: {@link PxPlane} [Const, Ref]
     * @param material WebIDL type: {@link PxMaterial} [Ref]
     * @return WebIDL type: {@link PxRigidStatic}
     */
    public static PxRigidStatic CreatePlane(PxPhysics sdk, PxPlane plane, PxMaterial material) {
        return PxRigidStatic.wrapPointer(_CreatePlane(sdk.getAddress(), plane.getAddress(), material.getAddress()));
    }
    private static native long _CreatePlane(long sdk, long plane, long material);

    /**
     * @param physics     WebIDL type: {@link PxPhysics} [Ref]
     * @param from        WebIDL type: {@link PxShape} [Const, Ref]
     * @param isExclusive WebIDL type: boolean
     * @return WebIDL type: {@link PxShape}
     */
    public static PxShape CloneShape(PxPhysics physics, PxShape from, boolean isExclusive) {
        return PxShape.wrapPointer(_CloneShape(physics.getAddress(), from.getAddress(), isExclusive));
    }
    private static native long _CloneShape(long physics, long from, boolean isExclusive);

    /**
     * @param physicsSDK WebIDL type: {@link PxPhysics} [Ref]
     * @param transform  WebIDL type: {@link PxTransform} [Const, Ref]
     * @param from       WebIDL type: {@link PxRigidActor} [Const, Ref]
     * @return WebIDL type: {@link PxRigidStatic}
     */
    public static PxRigidStatic CloneStatic(PxPhysics physicsSDK, PxTransform transform, PxRigidActor from) {
        return PxRigidStatic.wrapPointer(_CloneStatic(physicsSDK.getAddress(), transform.getAddress(), from.getAddress()));
    }
    private static native long _CloneStatic(long physicsSDK, long transform, long from);

    /**
     * @param physicsSDK WebIDL type: {@link PxPhysics} [Ref]
     * @param transform  WebIDL type: {@link PxTransform} [Const, Ref]
     * @param from       WebIDL type: {@link PxRigidDynamic} [Const, Ref]
     * @return WebIDL type: {@link PxRigidDynamic}
     */
    public static PxRigidDynamic CloneDynamic(PxPhysics physicsSDK, PxTransform transform, PxRigidDynamic from) {
        return PxRigidDynamic.wrapPointer(_CloneDynamic(physicsSDK.getAddress(), transform.getAddress(), from.getAddress()));
    }
    private static native long _CloneDynamic(long physicsSDK, long transform, long from);

    /**
     * @param actor          WebIDL type: {@link PxRigidActor} [Ref]
     * @param scale          WebIDL type: float
     * @param scaleMassProps WebIDL type: boolean
     */
    public static void ScaleRigidActor(PxRigidActor actor, float scale, boolean scaleMassProps) {
        _ScaleRigidActor(actor.getAddress(), scale, scaleMassProps);
    }
    private static native void _ScaleRigidActor(long actor, float scale, boolean scaleMassProps);

    /**
     * @param curTrans WebIDL type: {@link PxTransform} [Const, Ref]
     * @param linvel   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param angvel   WebIDL type: {@link PxVec3} [Const, Ref]
     * @param timeStep WebIDL type: float
     * @param result   WebIDL type: {@link PxTransform} [Ref]
     */
    public static void IntegrateTransform(PxTransform curTrans, PxVec3 linvel, PxVec3 angvel, float timeStep, PxTransform result) {
        _IntegrateTransform(curTrans.getAddress(), linvel.getAddress(), angvel.getAddress(), timeStep, result.getAddress());
    }
    private static native void _IntegrateTransform(long curTrans, long linvel, long angvel, float timeStep, long result);

}
