package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxMat33 extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxMat33 wrapPointer(long address) {
        return address != 0L ? new PxMat33(address) : null;
    }
    
    public static PxMat33 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxMat33(long address) {
        super(address);
    }

    // Constructors

    public PxMat33() {
        address = _PxMat33();
    }
    private static native long _PxMat33();

    /**
     * @param r WebIDL type: {@link PxIDENTITYEnum} [enum]
     */
    public PxMat33(PxIDENTITYEnum r) {
        address = _PxMat33(r.value);
    }
    private static native long _PxMat33(int r);

    /**
     * @param col0 WebIDL type: {@link PxVec3} [Const, Ref]
     * @param col1 WebIDL type: {@link PxVec3} [Const, Ref]
     * @param col2 WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public PxMat33(PxVec3 col0, PxVec3 col1, PxVec3 col2) {
        address = _PxMat33(col0.getAddress(), col1.getAddress(), col2.getAddress());
    }
    private static native long _PxMat33(long col0, long col1, long col2);

    /**
     * @param r WebIDL type: float
     */
    public PxMat33(float r) {
        PlatformChecks.requirePlatform(15, "physx.common.PxMat33");
        address = _PxMat33(r);
    }
    private static native long _PxMat33(float r);

    /**
     * @param q WebIDL type: {@link PxQuat} [Const, Ref]
     */
    public PxMat33(PxQuat q) {
        PlatformChecks.requirePlatform(15, "physx.common.PxMat33");
        address = _PxMat33(q.getAddress());
    }
    private static native long _PxMat33(long q);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getColumn0() {
        checkNotNull();
        return PxVec3.wrapPointer(_getColumn0(address));
    }
    private static native long _getColumn0(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setColumn0(PxVec3 value) {
        checkNotNull();
        _setColumn0(address, value.getAddress());
    }
    private static native void _setColumn0(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getColumn1() {
        checkNotNull();
        return PxVec3.wrapPointer(_getColumn1(address));
    }
    private static native long _getColumn1(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setColumn1(PxVec3 value) {
        checkNotNull();
        _setColumn1(address, value.getAddress());
    }
    private static native void _setColumn1(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getColumn2() {
        checkNotNull();
        return PxVec3.wrapPointer(_getColumn2(address));
    }
    private static native long _getColumn2(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setColumn2(PxVec3 value) {
        checkNotNull();
        _setColumn2(address, value.getAddress());
    }
    private static native void _setColumn2(long address, long value);

    // Functions

    /**
     * @return WebIDL type: {@link PxMat33} [Value]
     */
    public PxMat33 getTranspose() {
        checkNotNull();
        return PxMat33.wrapPointer(_getTranspose(address));
    }
    private static native long _getTranspose(long address);

    /**
     * @return WebIDL type: {@link PxMat33} [Value]
     */
    public PxMat33 getInverse() {
        checkNotNull();
        return PxMat33.wrapPointer(_getInverse(address));
    }
    private static native long _getInverse(long address);

    /**
     * @return WebIDL type: float
     */
    public float getDeterminant() {
        checkNotNull();
        return _getDeterminant(address);
    }
    private static native float _getDeterminant(long address);

    /**
     * @param other WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 transform(PxVec3 other) {
        checkNotNull();
        return PxVec3.wrapPointer(_transform(address, other.getAddress()));
    }
    private static native long _transform(long address, long other);

    /**
     * @param other WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 transformTranspose(PxVec3 other) {
        checkNotNull();
        return PxVec3.wrapPointer(_transformTranspose(address, other.getAddress()));
    }
    private static native long _transformTranspose(long address, long other);

}
