package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;

public class PxTransform extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxTransform wrapPointer(long address) {
        return address != 0L ? new PxTransform(address) : null;
    }
    
    public static PxTransform arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxTransform(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxTransform
     */
    public static PxTransform createAt(long address) {
        __placement_new_PxTransform(address);
        PxTransform createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxTransform
     */
    public static <T> PxTransform createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTransform(address);
        PxTransform createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTransform(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param r       WebIDL type: {@link PxIDENTITYEnum} [enum]
     * @return Stack allocated object of PxTransform
     */
    public static PxTransform createAt(long address, PxIDENTITYEnum r) {
        __placement_new_PxTransform(address, r.value);
        PxTransform createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param r         WebIDL type: {@link PxIDENTITYEnum} [enum]
     * @return Stack allocated object of PxTransform
     */
    public static <T> PxTransform createAt(T allocator, Allocator<T> allocate, PxIDENTITYEnum r) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTransform(address, r.value);
        PxTransform createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTransform(long address, int r);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param p0      WebIDL type: {@link PxVec3} [Const, Ref]
     * @param q0      WebIDL type: {@link PxQuat} [Const, Ref]
     * @return Stack allocated object of PxTransform
     */
    public static PxTransform createAt(long address, PxVec3 p0, PxQuat q0) {
        __placement_new_PxTransform(address, p0.getAddress(), q0.getAddress());
        PxTransform createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param p0        WebIDL type: {@link PxVec3} [Const, Ref]
     * @param q0        WebIDL type: {@link PxQuat} [Const, Ref]
     * @return Stack allocated object of PxTransform
     */
    public static <T> PxTransform createAt(T allocator, Allocator<T> allocate, PxVec3 p0, PxQuat q0) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTransform(address, p0.getAddress(), q0.getAddress());
        PxTransform createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTransform(long address, long p0, long q0);

    /**
     * @param address  Pre-allocated memory, where the object is created.
     * @param position WebIDL type: {@link PxVec3} [Const, Ref]
     * @return Stack allocated object of PxTransform
     */
    public static PxTransform createAt(long address, PxVec3 position) {
    PlatformChecks.requirePlatform(15, "physx.common.PxTransform");
        __placement_new_PxTransform(address, position.getAddress());
        PxTransform createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param position  WebIDL type: {@link PxVec3} [Const, Ref]
     * @return Stack allocated object of PxTransform
     */
    public static <T> PxTransform createAt(T allocator, Allocator<T> allocate, PxVec3 position) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxTransform(address, position.getAddress());
        PxTransform createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxTransform(long address, long position);

    // Constructors

    public PxTransform() {
        address = _PxTransform();
    }
    private static native long _PxTransform();

    /**
     * @param r WebIDL type: {@link PxIDENTITYEnum} [enum]
     */
    public PxTransform(PxIDENTITYEnum r) {
        address = _PxTransform(r.value);
    }
    private static native long _PxTransform(int r);

    /**
     * @param p0 WebIDL type: {@link PxVec3} [Const, Ref]
     * @param q0 WebIDL type: {@link PxQuat} [Const, Ref]
     */
    public PxTransform(PxVec3 p0, PxQuat q0) {
        address = _PxTransform(p0.getAddress(), q0.getAddress());
    }
    private static native long _PxTransform(long p0, long q0);

    /**
     * @param position WebIDL type: {@link PxVec3} [Const, Ref]
     */
    public PxTransform(PxVec3 position) {
        PlatformChecks.requirePlatform(15, "physx.common.PxTransform");
        address = _PxTransform(position.getAddress());
    }
    private static native long _PxTransform(long position);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * @return WebIDL type: {@link PxQuat} [Value]
     */
    public PxQuat getQ() {
        checkNotNull();
        return PxQuat.wrapPointer(_getQ(address));
    }
    private static native long _getQ(long address);

    /**
     * @param value WebIDL type: {@link PxQuat} [Value]
     */
    public void setQ(PxQuat value) {
        checkNotNull();
        _setQ(address, value.getAddress());
    }
    private static native void _setQ(long address, long value);

    /**
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 getP() {
        checkNotNull();
        return PxVec3.wrapPointer(_getP(address));
    }
    private static native long _getP(long address);

    /**
     * @param value WebIDL type: {@link PxVec3} [Value]
     */
    public void setP(PxVec3 value) {
        checkNotNull();
        _setP(address, value.getAddress());
    }
    private static native void _setP(long address, long value);

    // Functions

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getInverse() {
        checkNotNull();
        return PxTransform.wrapPointer(_getInverse(address));
    }
    private static native long _getInverse(long address);

    /**
     * @param input WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 transform(PxVec3 input) {
        checkNotNull();
        return PxVec3.wrapPointer(_transform(address, input.getAddress()));
    }
    private static native long _transform(long address, long input);

    /**
     * @param input WebIDL type: {@link PxVec3} [Const, Ref]
     * @return WebIDL type: {@link PxVec3} [Value]
     */
    public PxVec3 transformInv(PxVec3 input) {
        checkNotNull();
        return PxVec3.wrapPointer(_transformInv(address, input.getAddress()));
    }
    private static native long _transformInv(long address, long input);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isSane() {
        checkNotNull();
        return _isSane(address);
    }
    private static native boolean _isSane(long address);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isFinite() {
        checkNotNull();
        return _isFinite(address);
    }
    private static native boolean _isFinite(long address);

    /**
     * @return WebIDL type: {@link PxTransform} [Value]
     */
    public PxTransform getNormalized() {
        checkNotNull();
        return PxTransform.wrapPointer(_getNormalized(address));
    }
    private static native long _getNormalized(long address);

}
