package physx.physics;

/**
 * Desired build strategy for bounding-volume hierarchies
 */
public enum PxBVHBuildStrategyEnum {

    /**
     * Fast build strategy. Fast build speed, good runtime performance in most cases. Recommended for runtime cooking.
     */
    eFAST(geteFAST()),
    /**
     * Default build strategy. Medium build speed, good runtime performance in all cases.
     */
    eDEFAULT(geteDEFAULT()),
    /**
     * SAH build strategy. Slower builds, slightly improved runtime performance in some cases.
     */
    eSAH(geteSAH());
    public final int value;
    
    PxBVHBuildStrategyEnum(int value) {
        this.value = value;
    }

    private static native int _geteFAST();
    private static int geteFAST() {
        de.fabmax.physxjni.Loader.load();
        return _geteFAST();
    }

    private static native int _geteDEFAULT();
    private static int geteDEFAULT() {
        de.fabmax.physxjni.Loader.load();
        return _geteDEFAULT();
    }

    private static native int _geteSAH();
    private static int geteSAH() {
        de.fabmax.physxjni.Loader.load();
        return _geteSAH();
    }

    public static PxBVHBuildStrategyEnum forValue(int value) {
        for (int i = 0; i < values().length; i++) {
            if (values()[i].value == value) {
                return values()[i];
            }
        }
        throw new IllegalArgumentException("Unknown value for enum PxBVHBuildStrategyEnum: " + value);
    }

}
