package physx.support;

import physx.NativeObject;
import physx.physics.PxMaterial;

public class PxArray_PxMaterialConst extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxArray_PxMaterialConst wrapPointer(long address) {
        return address != 0L ? new PxArray_PxMaterialConst(address) : null;
    }
    
    public static PxArray_PxMaterialConst arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxArray_PxMaterialConst(long address) {
        super(address);
    }

    // Placed Constructors

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @return Stack allocated object of PxArray_PxMaterialConst
     */
    public static PxArray_PxMaterialConst createAt(long address) {
        __placement_new_PxArray_PxMaterialConst(address);
        PxArray_PxMaterialConst createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @return Stack allocated object of PxArray_PxMaterialConst
     */
    public static <T> PxArray_PxMaterialConst createAt(T allocator, Allocator<T> allocate) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxMaterialConst(address);
        PxArray_PxMaterialConst createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxMaterialConst(long address);

    /**
     * @param address Pre-allocated memory, where the object is created.
     * @param size    WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxMaterialConst
     */
    public static PxArray_PxMaterialConst createAt(long address, int size) {
        __placement_new_PxArray_PxMaterialConst(address, size);
        PxArray_PxMaterialConst createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    /**
     * @param <T>       Allocator class, e.g. LWJGL's MemoryStack.
     * @param allocator Object to use for allocation, e.g. an instance of LWJGL's MemoryStack.
     * @param allocate  Method to call on allocator to obtain the target address, e.g. MemoryStack::nmalloc.
     * @param size      WebIDL type: unsigned long
     * @return Stack allocated object of PxArray_PxMaterialConst
     */
    public static <T> PxArray_PxMaterialConst createAt(T allocator, Allocator<T> allocate, int size) {
        long address = allocate.on(allocator, ALIGNOF, SIZEOF); 
        __placement_new_PxArray_PxMaterialConst(address, size);
        PxArray_PxMaterialConst createdObj = wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    private static native void __placement_new_PxArray_PxMaterialConst(long address, int size);

    // Constructors

    public PxArray_PxMaterialConst() {
        address = _PxArray_PxMaterialConst();
    }
    private static native long _PxArray_PxMaterialConst();

    /**
     * @param size WebIDL type: unsigned long
     */
    public PxArray_PxMaterialConst(int size) {
        address = _PxArray_PxMaterialConst(size);
    }
    private static native long _PxArray_PxMaterialConst(int size);

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param index WebIDL type: unsigned long
     * @return WebIDL type: {@link PxMaterial} [Const]
     */
    public PxMaterial get(int index) {
        checkNotNull();
        return PxMaterial.wrapPointer(_get(address, index));
    }
    private static native long _get(long address, int index);

    /**
     * @param index WebIDL type: unsigned long
     * @param value WebIDL type: {@link PxMaterialConstPtr} [Const, Ref]
     */
    public void set(int index, PxMaterialConstPtr value) {
        checkNotNull();
        _set(address, index, value.getAddress());
    }
    private static native void _set(long address, int index, long value);

    /**
     * @return WebIDL type: {@link PxMaterialConstPtr}
     */
    public PxMaterialConstPtr begin() {
        checkNotNull();
        return PxMaterialConstPtr.wrapPointer(_begin(address));
    }
    private static native long _begin(long address);

    /**
     * @return WebIDL type: unsigned long
     */
    public int size() {
        checkNotNull();
        return _size(address);
    }
    private static native int _size(long address);

    /**
     * @param value WebIDL type: {@link PxMaterial} [Const]
     */
    public void pushBack(PxMaterial value) {
        checkNotNull();
        _pushBack(address, value.getAddress());
    }
    private static native void _pushBack(long address, long value);

    public void clear() {
        checkNotNull();
        _clear(address);
    }
    private static native void _clear(long address);

}
