package physx.vehicle2;

import physx.NativeObject;
import physx.common.PxVec3;

/**
 * The anti-roll torque of all anti-roll bars accumulates in a single torque to apply
 * to the vehicle's rigid body.
 */
public class PxVehicleAntiRollTorque extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleAntiRollTorque wrapPointer(long address) {
        return address != 0L ? new PxVehicleAntiRollTorque(address) : null;
    }
    
    public static PxVehicleAntiRollTorque arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleAntiRollTorque(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleAntiRollTorque() {
        address = _PxVehicleAntiRollTorque();
    }
    private static native long _PxVehicleAntiRollTorque();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * The accumulated torque to apply to the rigid body.
     * <b>Note:</b> antiRollTorque is expressed in the world frame.
     * <p>
     * <b>Unit:</b> mass * (length^2) / (time^2)
     */
    public PxVec3 getAntiRollTorque() {
        checkNotNull();
        return PxVec3.wrapPointer(_getAntiRollTorque(address));
    }
    private static native long _getAntiRollTorque(long address);

    /**
     * The accumulated torque to apply to the rigid body.
     * <b>Note:</b> antiRollTorque is expressed in the world frame.
     * <p>
     * <b>Unit:</b> mass * (length^2) / (time^2)
     */
    public void setAntiRollTorque(PxVec3 value) {
        checkNotNull();
        _setAntiRollTorque(address, value.getAddress());
    }
    private static native void _setAntiRollTorque(long address, long value);

    // Functions

    public void setToDefault() {
        checkNotNull();
        _setToDefault(address);
    }
    private static native void _setToDefault(long address);

}
