package physx.vehicle2;


/**
 * Distribute a steer response to the wheels of a vehicle.
 * <b>Note:</b> The steer angle applied to each wheel on the ith wheel is steerCommand * maxResponse * wheelResponseMultipliers[i].
 * <b>Note:</b> A typical use case is to set maxResponse to be the vehicle's maximum achievable steer angle
 * that occurs when the steer command is equal to 1.0. The array wheelResponseMultipliers[i] would then be used
 * to specify the maximum achievable steer angle per wheel as a fractional multiplier of the vehicle's maximum achievable steer angle.
 */
public class PxVehicleSteerCommandResponseParams extends PxVehicleCommandResponseParams {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSteerCommandResponseParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleSteerCommandResponseParams(address) : null;
    }
    
    public static PxVehicleSteerCommandResponseParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSteerCommandResponseParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSteerCommandResponseParams() {
        address = _PxVehicleSteerCommandResponseParams();
    }
    private static native long _PxVehicleSteerCommandResponseParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleSteerCommandResponseParams} [Value]
     */
    public PxVehicleSteerCommandResponseParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleSteerCommandResponseParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @param axleDesc WebIDL type: {@link PxVehicleAxleDescription} [Const, Ref]
     * @return WebIDL type: boolean
     */
    public boolean isValid(PxVehicleAxleDescription axleDesc) {
        checkNotNull();
        return _isValid(address, axleDesc.getAddress());
    }
    private static native boolean _isValid(long address, long axleDesc);

}
