package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleSuspensionState extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionState wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionState(address) : null;
    }
    
    public static PxVehicleSuspensionState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionState(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionState() {
        address = _PxVehicleSuspensionState();
    }
    private static native long _PxVehicleSuspensionState();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     * jounce is the distance from maximum droop.
     * <b>Note:</b> jounce is positive semi-definite
     * <b>Note:</b> A value of 0.0 represents the suspension at maximum droop and zero suspension force.
     * <b>Note:</b> A value of suspensionTravelDist represents the suspension at maximum compression.
     * <b>Note:</b> jounce is clamped in range [0, suspensionTravelDist].
     */
    public float getJounce() {
        checkNotNull();
        return _getJounce(address);
    }
    private static native float _getJounce(long address);

    /**
     * jounce is the distance from maximum droop.
     * <b>Note:</b> jounce is positive semi-definite
     * <b>Note:</b> A value of 0.0 represents the suspension at maximum droop and zero suspension force.
     * <b>Note:</b> A value of suspensionTravelDist represents the suspension at maximum compression.
     * <b>Note:</b> jounce is clamped in range [0, suspensionTravelDist].
     */
    public void setJounce(float value) {
        checkNotNull();
        _setJounce(address, value);
    }
    private static native void _setJounce(long address, float value);

    /**
     * jounceSpeed is the rate of change of jounce.
     */
    public float getJounceSpeed() {
        checkNotNull();
        return _getJounceSpeed(address);
    }
    private static native float _getJounceSpeed(long address);

    /**
     * jounceSpeed is the rate of change of jounce.
     */
    public void setJounceSpeed(float value) {
        checkNotNull();
        _setJounceSpeed(address, value);
    }
    private static native void _setJounceSpeed(long address, float value);

    /**
     * separation holds extra information about the contact state of the wheel with the ground.
     * <p>
     * If the suspension travel range is enough to place the wheel on the ground, then separation will be 0.
     * If separation holds a negative value, then the wheel penetrates into the ground at maximum compression
     * as well as maximum droop. The suspension would need to go beyond maximum compression (ground normal
     * pointing in opposite direction of suspension) or beyond maximum droop (ground normal pointing in same
     * direction as suspension) to place the wheel on the ground. In that case the separation value defines
     * how much the wheel penetrates into the ground along the ground plane normal. This penetration may be
     * resolved by using a constraint that simulates the effect of a bump stop.
     * If separation holds a positive value, then the wheel does not penetrate the ground at maximum droop
     * but can not touch the ground because the suspension would need to expand beyond max droop to reach it
     * or because the suspension could not expand fast enough to reach the ground.
     */
    public float getSeparation() {
        checkNotNull();
        return _getSeparation(address);
    }
    private static native float _getSeparation(long address);

    /**
     * separation holds extra information about the contact state of the wheel with the ground.
     * <p>
     * If the suspension travel range is enough to place the wheel on the ground, then separation will be 0.
     * If separation holds a negative value, then the wheel penetrates into the ground at maximum compression
     * as well as maximum droop. The suspension would need to go beyond maximum compression (ground normal
     * pointing in opposite direction of suspension) or beyond maximum droop (ground normal pointing in same
     * direction as suspension) to place the wheel on the ground. In that case the separation value defines
     * how much the wheel penetrates into the ground along the ground plane normal. This penetration may be
     * resolved by using a constraint that simulates the effect of a bump stop.
     * If separation holds a positive value, then the wheel does not penetrate the ground at maximum droop
     * but can not touch the ground because the suspension would need to expand beyond max droop to reach it
     * or because the suspension could not expand fast enough to reach the ground.
     */
    public void setSeparation(float value) {
        checkNotNull();
        _setSeparation(address, value);
    }
    private static native void _setSeparation(long address, float value);

    // Functions

    /**
     * @param _jounce     WebIDL type: float
     * @param _separation WebIDL type: float
     */
    public void setToDefault(float _jounce, float _separation) {
        checkNotNull();
        _setToDefault(address, _jounce, _separation);
    }
    private static native void _setToDefault(long address, float _jounce, float _separation);

}
