package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleSuspensionStateCalculationParams extends NativeObject {

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleSuspensionStateCalculationParams wrapPointer(long address) {
        return address != 0L ? new PxVehicleSuspensionStateCalculationParams(address) : null;
    }
    
    public static PxVehicleSuspensionStateCalculationParams arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleSuspensionStateCalculationParams(long address) {
        super(address);
    }

    // Constructors

    public PxVehicleSuspensionStateCalculationParams() {
        address = _PxVehicleSuspensionStateCalculationParams();
    }
    private static native long _PxVehicleSuspensionStateCalculationParams();

    // Destructor

    public void destroy() {
        if (address == 0L) {
            throw new IllegalStateException(this + " is already deleted");
        }
        if (isExternallyAllocated) {
            throw new IllegalStateException(this + " is externally allocated and cannot be manually destroyed");
        }
        _delete_native_instance(address);
        address = 0L;
    }
    private static native long _delete_native_instance(long address);

    // Attributes

    /**
     */
    public PxVehicleSuspensionJounceCalculationTypeEnum getSuspensionJounceCalculationType() {
        checkNotNull();
        return PxVehicleSuspensionJounceCalculationTypeEnum.forValue(_getSuspensionJounceCalculationType(address));
    }
    private static native int _getSuspensionJounceCalculationType(long address);

    /**
     */
    public void setSuspensionJounceCalculationType(PxVehicleSuspensionJounceCalculationTypeEnum value) {
        checkNotNull();
        _setSuspensionJounceCalculationType(address, value.value);
    }
    private static native void _setSuspensionJounceCalculationType(long address, int value);

    /**
     * Limit the suspension expansion dynamics.
     * <p>
     * If a hit with the ground is detected, the suspension jounce will be set such that the wheel
     * is placed on the ground. This can result in large changes to jounce within a single
     * simulation frame, if the ground surface has high frequency or if the simulation time step
     * is large. As a result, large damping forces can evolve and cause undesired behavior. If this
     * parameter is set to true, the suspension expansion speed will be limited to what can be
     * achieved given the time step, suspension stiffness etc. As a consequence, handling of the
     * vehicle will be affected as the wheel might loose contact with the ground more easily.
     */
    public boolean getLimitSuspensionExpansionVelocity() {
        checkNotNull();
        return _getLimitSuspensionExpansionVelocity(address);
    }
    private static native boolean _getLimitSuspensionExpansionVelocity(long address);

    /**
     * Limit the suspension expansion dynamics.
     * <p>
     * If a hit with the ground is detected, the suspension jounce will be set such that the wheel
     * is placed on the ground. This can result in large changes to jounce within a single
     * simulation frame, if the ground surface has high frequency or if the simulation time step
     * is large. As a result, large damping forces can evolve and cause undesired behavior. If this
     * parameter is set to true, the suspension expansion speed will be limited to what can be
     * achieved given the time step, suspension stiffness etc. As a consequence, handling of the
     * vehicle will be affected as the wheel might loose contact with the ground more easily.
     */
    public void setLimitSuspensionExpansionVelocity(boolean value) {
        checkNotNull();
        _setLimitSuspensionExpansionVelocity(address, value);
    }
    private static native void _setLimitSuspensionExpansionVelocity(long address, boolean value);

    // Functions

    /**
     * @param srcFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param trgFrame WebIDL type: {@link PxVehicleFrame} [Const, Ref]
     * @param srcScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @param trgScale WebIDL type: {@link PxVehicleScale} [Const, Ref]
     * @return WebIDL type: {@link PxVehicleSuspensionStateCalculationParams} [Value]
     */
    public PxVehicleSuspensionStateCalculationParams transformAndScale(PxVehicleFrame srcFrame, PxVehicleFrame trgFrame, PxVehicleScale srcScale, PxVehicleScale trgScale) {
        checkNotNull();
        return PxVehicleSuspensionStateCalculationParams.wrapPointer(_transformAndScale(address, srcFrame.getAddress(), trgFrame.getAddress(), srcScale.getAddress(), trgScale.getAddress()));
    }
    private static native long _transformAndScale(long address, long srcFrame, long trgFrame, long srcScale, long trgScale);

    /**
     * @return WebIDL type: boolean
     */
    public boolean isValid() {
        checkNotNull();
        return _isValid(address);
    }
    private static native boolean _isValid(long address);

}
