package physx.vehicle2;

import physx.NativeObject;

public class PxVehicleTireForceParamsExt extends NativeObject {

    protected PxVehicleTireForceParamsExt() { }

    private static native int __sizeOf();
    public static final int SIZEOF = __sizeOf();
    public static final int ALIGNOF = 8;
    
    public static PxVehicleTireForceParamsExt wrapPointer(long address) {
        return address != 0L ? new PxVehicleTireForceParamsExt(address) : null;
    }
    
    public static PxVehicleTireForceParamsExt arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) throw new NullPointerException("baseAddress is 0");
        return wrapPointer(baseAddress + (long) SIZEOF * index);
    }
    
    protected PxVehicleTireForceParamsExt(long address) {
        super(address);
    }

    // Functions

    /**
     * @param tireForceParams WebIDL type: {@link PxVehicleTireForceParams}
     * @param i               WebIDL type: unsigned long
     * @param j               WebIDL type: unsigned long
     * @param value           WebIDL type: float
     */
    public static void setFrictionVsSlip(PxVehicleTireForceParams tireForceParams, int i, int j, float value) {
        _setFrictionVsSlip(tireForceParams.getAddress(), i, j, value);
    }
    private static native void _setFrictionVsSlip(long tireForceParams, int i, int j, float value);

    /**
     * @param tireForceParams WebIDL type: {@link PxVehicleTireForceParams}
     * @param i               WebIDL type: unsigned long
     * @param j               WebIDL type: unsigned long
     * @param value           WebIDL type: float
     */
    public static void setLoadFilter(PxVehicleTireForceParams tireForceParams, int i, int j, float value) {
        _setLoadFilter(tireForceParams.getAddress(), i, j, value);
    }
    private static native void _setLoadFilter(long tireForceParams, int i, int j, float value);

}
