/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.NativeObject;
import physx.character.PxControllerDesc;

public class PxBoxControllerDesc
extends PxControllerDesc {
    public static final int SIZEOF = PxBoxControllerDesc.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxBoxControllerDesc wrapPointer(long address) {
        return address != 0L ? new PxBoxControllerDesc(address) : null;
    }

    public static PxBoxControllerDesc arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxBoxControllerDesc.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxBoxControllerDesc(long address) {
        super(address);
    }

    public static PxBoxControllerDesc createAt(long address) {
        Raw.PxBoxControllerDesc_placed(address);
        PxBoxControllerDesc createdObj = PxBoxControllerDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxBoxControllerDesc createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxBoxControllerDesc_placed(address);
        PxBoxControllerDesc createdObj = PxBoxControllerDesc.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxBoxControllerDesc() {
        this.address = Raw.PxBoxControllerDesc();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getHalfHeight() {
        this.checkNotNull();
        return Raw.getHalfHeight(this.address);
    }

    public void setHalfHeight(float value) {
        this.checkNotNull();
        Raw.setHalfHeight(this.address, value);
    }

    public float getHalfSideExtent() {
        this.checkNotNull();
        return Raw.getHalfSideExtent(this.address);
    }

    public void setHalfSideExtent(float value) {
        this.checkNotNull();
        Raw.setHalfSideExtent(this.address, value);
    }

    public float getHalfForwardExtent() {
        this.checkNotNull();
        return Raw.getHalfForwardExtent(this.address);
    }

    public void setHalfForwardExtent(float value) {
        this.checkNotNull();
        Raw.setHalfForwardExtent(this.address, value);
    }

    public void setToDefault() {
        this.checkNotNull();
        Raw.setToDefault(this.address);
    }

    public static class Raw {
        public static native void PxBoxControllerDesc_placed(long var0);

        public static native long PxBoxControllerDesc();

        public static native void destroy(long var0);

        public static native float getHalfHeight(long var0);

        public static native void setHalfHeight(long var0, float var2);

        public static native float getHalfSideExtent(long var0);

        public static native void setHalfSideExtent(long var0, float var2);

        public static native float getHalfForwardExtent(long var0);

        public static native void setHalfForwardExtent(long var0, float var2);

        public static native void setToDefault(long var0);
    }
}

