/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.character.PxObstacle;
import physx.common.PxVec3;

public class PxBoxObstacle
extends PxObstacle {
    public static final int SIZEOF = PxBoxObstacle.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxBoxObstacle wrapPointer(long address) {
        return address != 0L ? new PxBoxObstacle(address) : null;
    }

    public static PxBoxObstacle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxBoxObstacle.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxBoxObstacle(long address) {
        super(address);
    }

    public PxBoxObstacle() {
        this.address = Raw.PxBoxObstacle();
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getMHalfExtents() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getMHalfExtents(this.address));
    }

    public void setMHalfExtents(PxVec3 value) {
        this.checkNotNull();
        Raw.setMHalfExtents(this.address, value.getAddress());
    }

    public static class Raw {
        public static native long PxBoxObstacle();

        public static native void destroy(long var0);

        public static native long getMHalfExtents(long var0);

        public static native void setMHalfExtents(long var0, long var2);
    }
}

