/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.character.PxObstacle;

public class PxCapsuleObstacle
extends PxObstacle {
    public static final int SIZEOF = PxCapsuleObstacle.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxCapsuleObstacle wrapPointer(long address) {
        return address != 0L ? new PxCapsuleObstacle(address) : null;
    }

    public static PxCapsuleObstacle arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxCapsuleObstacle.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxCapsuleObstacle(long address) {
        super(address);
    }

    public PxCapsuleObstacle() {
        this.address = Raw.PxCapsuleObstacle();
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getMHalfHeight() {
        this.checkNotNull();
        return Raw.getMHalfHeight(this.address);
    }

    public void setMHalfHeight(float value) {
        this.checkNotNull();
        Raw.setMHalfHeight(this.address, value);
    }

    public float getMRadius() {
        this.checkNotNull();
        return Raw.getMRadius(this.address);
    }

    public void setMRadius(float value) {
        this.checkNotNull();
        Raw.setMRadius(this.address, value);
    }

    public static class Raw {
        public static native long PxCapsuleObstacle();

        public static native void destroy(long var0);

        public static native float getMHalfHeight(long var0);

        public static native void setMHalfHeight(long var0, float var2);

        public static native float getMRadius(long var0);

        public static native void setMRadius(long var0, float var2);
    }
}

