/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.NativeObject;
import physx.character.PxController;
import physx.character.PxControllerDesc;
import physx.character.PxObstacleContext;
import physx.common.PxVec3;
import physx.physics.PxScene;

public class PxControllerManager
extends NativeObject {
    public static final int SIZEOF = PxControllerManager.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxControllerManager() {
    }

    private static native int __sizeOf();

    public static PxControllerManager wrapPointer(long address) {
        return address != 0L ? new PxControllerManager(address) : null;
    }

    public static PxControllerManager arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxControllerManager.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxControllerManager(long address) {
        super(address);
    }

    public void release() {
        this.checkNotNull();
        Raw.release(this.address);
    }

    public PxScene getScene() {
        this.checkNotNull();
        return PxScene.wrapPointer(Raw.getScene(this.address));
    }

    public int getNbControllers() {
        this.checkNotNull();
        return Raw.getNbControllers(this.address);
    }

    public PxController getController(int index) {
        this.checkNotNull();
        return PxController.wrapPointer(Raw.getController(this.address, index));
    }

    public PxController createController(PxControllerDesc desc) {
        this.checkNotNull();
        return PxController.wrapPointer(Raw.createController(this.address, desc.getAddress()));
    }

    public void purgeControllers() {
        this.checkNotNull();
        Raw.purgeControllers(this.address);
    }

    public int getNbObstacleContexts() {
        this.checkNotNull();
        return Raw.getNbObstacleContexts(this.address);
    }

    public PxObstacleContext getObstacleContext(int index) {
        this.checkNotNull();
        return PxObstacleContext.wrapPointer(Raw.getObstacleContext(this.address, index));
    }

    public PxObstacleContext createObstacleContext() {
        this.checkNotNull();
        return PxObstacleContext.wrapPointer(Raw.createObstacleContext(this.address));
    }

    public void computeInteractions(float elapsedTime) {
        this.checkNotNull();
        Raw.computeInteractions(this.address, elapsedTime);
    }

    public void setTessellation(boolean flag, float maxEdgeLength) {
        this.checkNotNull();
        Raw.setTessellation(this.address, flag, maxEdgeLength);
    }

    public void setOverlapRecoveryModule(boolean flag) {
        this.checkNotNull();
        Raw.setOverlapRecoveryModule(this.address, flag);
    }

    public void setPreciseSweeps(boolean flags) {
        this.checkNotNull();
        Raw.setPreciseSweeps(this.address, flags);
    }

    public void setPreventVerticalSlidingAgainstCeiling(boolean flag) {
        this.checkNotNull();
        Raw.setPreventVerticalSlidingAgainstCeiling(this.address, flag);
    }

    public void shiftOrigin(PxVec3 shift) {
        this.checkNotNull();
        Raw.shiftOrigin(this.address, shift.getAddress());
    }

    public static class Raw {
        public static native void release(long var0);

        public static native long getScene(long var0);

        public static native int getNbControllers(long var0);

        public static native long getController(long var0, int var2);

        public static native long createController(long var0, long var2);

        public static native void purgeControllers(long var0);

        public static native int getNbObstacleContexts(long var0);

        public static native long getObstacleContext(long var0, int var2);

        public static native long createObstacleContext(long var0);

        public static native void computeInteractions(long var0, float var2);

        public static native void setTessellation(long var0, boolean var2, float var3);

        public static native void setOverlapRecoveryModule(long var0, boolean var2);

        public static native void setPreciseSweeps(long var0, boolean var2);

        public static native void setPreventVerticalSlidingAgainstCeiling(long var0, boolean var2);

        public static native void shiftOrigin(long var0, long var2);
    }
}

