/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.physics.PxRigidActor;
import physx.physics.PxShape;

public class PxControllerState
extends NativeObject {
    public static final int SIZEOF = PxControllerState.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxControllerState wrapPointer(long address) {
        return address != 0L ? new PxControllerState(address) : null;
    }

    public static PxControllerState arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxControllerState.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxControllerState(long address) {
        super(address);
    }

    public PxControllerState() {
        this.address = Raw.PxControllerState();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getDeltaXP() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getDeltaXP(this.address));
    }

    public void setDeltaXP(PxVec3 value) {
        this.checkNotNull();
        Raw.setDeltaXP(this.address, value.getAddress());
    }

    public PxShape getTouchedShape() {
        this.checkNotNull();
        return PxShape.wrapPointer(Raw.getTouchedShape(this.address));
    }

    public void setTouchedShape(PxShape value) {
        this.checkNotNull();
        Raw.setTouchedShape(this.address, value.getAddress());
    }

    public PxRigidActor getTouchedActor() {
        this.checkNotNull();
        return PxRigidActor.wrapPointer(Raw.getTouchedActor(this.address));
    }

    public void setTouchedActor(PxRigidActor value) {
        this.checkNotNull();
        Raw.setTouchedActor(this.address, value.getAddress());
    }

    public int getTouchedObstacleHandle() {
        this.checkNotNull();
        return Raw.getTouchedObstacleHandle(this.address);
    }

    public void setTouchedObstacleHandle(int value) {
        this.checkNotNull();
        Raw.setTouchedObstacleHandle(this.address, value);
    }

    public int getCollisionFlags() {
        this.checkNotNull();
        return Raw.getCollisionFlags(this.address);
    }

    public void setCollisionFlags(int value) {
        this.checkNotNull();
        Raw.setCollisionFlags(this.address, value);
    }

    public boolean getStandOnAnotherCCT() {
        this.checkNotNull();
        return Raw.getStandOnAnotherCCT(this.address);
    }

    public void setStandOnAnotherCCT(boolean value) {
        this.checkNotNull();
        Raw.setStandOnAnotherCCT(this.address, value);
    }

    public boolean getStandOnObstacle() {
        this.checkNotNull();
        return Raw.getStandOnObstacle(this.address);
    }

    public void setStandOnObstacle(boolean value) {
        this.checkNotNull();
        Raw.setStandOnObstacle(this.address, value);
    }

    public boolean getIsMovingUp() {
        this.checkNotNull();
        return Raw.getIsMovingUp(this.address);
    }

    public void setIsMovingUp(boolean value) {
        this.checkNotNull();
        Raw.setIsMovingUp(this.address, value);
    }

    public static class Raw {
        public static native long PxControllerState();

        public static native void destroy(long var0);

        public static native long getDeltaXP(long var0);

        public static native void setDeltaXP(long var0, long var2);

        public static native long getTouchedShape(long var0);

        public static native void setTouchedShape(long var0, long var2);

        public static native long getTouchedActor(long var0);

        public static native void setTouchedActor(long var0, long var2);

        public static native int getTouchedObstacleHandle(long var0);

        public static native void setTouchedObstacleHandle(long var0, int var2);

        public static native int getCollisionFlags(long var0);

        public static native void setCollisionFlags(long var0, int var2);

        public static native boolean getStandOnAnotherCCT(long var0);

        public static native void setStandOnAnotherCCT(long var0, boolean var2);

        public static native boolean getStandOnObstacle(long var0);

        public static native void setStandOnObstacle(long var0, boolean var2);

        public static native boolean getIsMovingUp(long var0);

        public static native void setIsMovingUp(long var0, boolean var2);
    }
}

