/*
 * Decompiled with CFR 0.152.
 */
package physx.character;

import physx.NativeObject;

public class PxControllerStats
extends NativeObject {
    public static final int SIZEOF = PxControllerStats.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxControllerStats() {
    }

    private static native int __sizeOf();

    public static PxControllerStats wrapPointer(long address) {
        return address != 0L ? new PxControllerStats(address) : null;
    }

    public static PxControllerStats arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxControllerStats.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxControllerStats(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public short getNbIterations() {
        this.checkNotNull();
        return Raw.getNbIterations(this.address);
    }

    public void setNbIterations(short value) {
        this.checkNotNull();
        Raw.setNbIterations(this.address, value);
    }

    public short getNbFullUpdates() {
        this.checkNotNull();
        return Raw.getNbFullUpdates(this.address);
    }

    public void setNbFullUpdates(short value) {
        this.checkNotNull();
        Raw.setNbFullUpdates(this.address, value);
    }

    public short getNbPartialUpdates() {
        this.checkNotNull();
        return Raw.getNbPartialUpdates(this.address);
    }

    public void setNbPartialUpdates(short value) {
        this.checkNotNull();
        Raw.setNbPartialUpdates(this.address, value);
    }

    public short getNbTessellation() {
        this.checkNotNull();
        return Raw.getNbTessellation(this.address);
    }

    public void setNbTessellation(short value) {
        this.checkNotNull();
        Raw.setNbTessellation(this.address, value);
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native short getNbIterations(long var0);

        public static native void setNbIterations(long var0, short var2);

        public static native short getNbFullUpdates(long var0);

        public static native void setNbFullUpdates(long var0, short var2);

        public static native short getNbPartialUpdates(long var0);

        public static native void setNbPartialUpdates(long var0, short var2);

        public static native short getNbTessellation(long var0);

        public static native void setNbTessellation(long var0, short var2);
    }
}

