/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.common.PxBaseFlagEnum;
import physx.common.PxBaseFlags;

public class PxBase
extends NativeObject {
    public static final int SIZEOF = PxBase.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxBase() {
    }

    private static native int __sizeOf();

    public static PxBase wrapPointer(long address) {
        return address != 0L ? new PxBase(address) : null;
    }

    public static PxBase arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxBase.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxBase(long address) {
        super(address);
    }

    public void release() {
        this.checkNotNull();
        Raw.release(this.address);
    }

    public String getConcreteTypeName() {
        this.checkNotNull();
        return Raw.getConcreteTypeName(this.address);
    }

    public int getConcreteType() {
        this.checkNotNull();
        return Raw.getConcreteType(this.address);
    }

    public void setBaseFlag(PxBaseFlagEnum flag, boolean value) {
        this.checkNotNull();
        Raw.setBaseFlag(this.address, flag.value, value);
    }

    public void setBaseFlags(PxBaseFlags inFlags) {
        this.checkNotNull();
        Raw.setBaseFlags(this.address, inFlags.getAddress());
    }

    public PxBaseFlags getBaseFlags() {
        this.checkNotNull();
        return PxBaseFlags.wrapPointer(Raw.getBaseFlags(this.address));
    }

    public boolean isReleasable() {
        this.checkNotNull();
        return Raw.isReleasable(this.address);
    }

    public static class Raw {
        public static native void release(long var0);

        public static native String getConcreteTypeName(long var0);

        public static native int getConcreteType(long var0);

        public static native void setBaseFlag(long var0, int var2, boolean var3);

        public static native void setBaseFlags(long var0, long var2);

        public static native long getBaseFlags(long var0);

        public static native boolean isReleasable(long var0);
    }
}

