/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.common.PxStridedData;

public class PxBoundedData
extends PxStridedData {
    public static final int SIZEOF = PxBoundedData.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxBoundedData wrapPointer(long address) {
        return address != 0L ? new PxBoundedData(address) : null;
    }

    public static PxBoundedData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxBoundedData.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxBoundedData(long address) {
        super(address);
    }

    public static PxBoundedData createAt(long address) {
        Raw.PxBoundedData_placed(address);
        PxBoundedData createdObj = PxBoundedData.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxBoundedData createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxBoundedData_placed(address);
        PxBoundedData createdObj = PxBoundedData.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxBoundedData() {
        this.address = Raw.PxBoundedData();
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getCount() {
        this.checkNotNull();
        return Raw.getCount(this.address);
    }

    public void setCount(int value) {
        this.checkNotNull();
        Raw.setCount(this.address, value);
    }

    public static class Raw {
        public static native void PxBoundedData_placed(long var0);

        public static native long PxBoundedData();

        public static native void destroy(long var0);

        public static native int getCount(long var0);

        public static native void setCount(long var0, int var2);
    }
}

