/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;

public class PxDefaultAllocator
extends NativeObject {
    public static final int SIZEOF = PxDefaultAllocator.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxDefaultAllocator wrapPointer(long address) {
        return address != 0L ? new PxDefaultAllocator(address) : null;
    }

    public static PxDefaultAllocator arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxDefaultAllocator.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxDefaultAllocator(long address) {
        super(address);
    }

    public PxDefaultAllocator() {
        this.address = Raw.PxDefaultAllocator();
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public static class Raw {
        public static native long PxDefaultAllocator();

        public static native void destroy(long var0);
    }
}

