/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxIDENTITYEnum;
import physx.common.PxQuat;
import physx.common.PxVec3;

public class PxMat33
extends NativeObject {
    public static final int SIZEOF = PxMat33.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxMat33 wrapPointer(long address) {
        return address != 0L ? new PxMat33(address) : null;
    }

    public static PxMat33 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxMat33.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxMat33(long address) {
        super(address);
    }

    public PxMat33() {
        this.address = Raw.PxMat33();
    }

    public PxMat33(PxIDENTITYEnum r) {
        this.address = Raw.PxMat33(r.value);
    }

    public PxMat33(PxVec3 col0, PxVec3 col1, PxVec3 col2) {
        this.address = Raw.PxMat33(col0.getAddress(), col1.getAddress(), col2.getAddress());
    }

    public PxMat33(float r) {
        PlatformChecks.requirePlatform(15, "physx.common.PxMat33");
        this.address = Raw.PxMat33(r);
    }

    public PxMat33(PxQuat q) {
        PlatformChecks.requirePlatform(15, "physx.common.PxMat33");
        this.address = Raw.PxMat33(q.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getColumn0() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getColumn0(this.address));
    }

    public void setColumn0(PxVec3 value) {
        this.checkNotNull();
        Raw.setColumn0(this.address, value.getAddress());
    }

    public PxVec3 getColumn1() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getColumn1(this.address));
    }

    public void setColumn1(PxVec3 value) {
        this.checkNotNull();
        Raw.setColumn1(this.address, value.getAddress());
    }

    public PxVec3 getColumn2() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getColumn2(this.address));
    }

    public void setColumn2(PxVec3 value) {
        this.checkNotNull();
        Raw.setColumn2(this.address, value.getAddress());
    }

    public PxMat33 getTranspose() {
        this.checkNotNull();
        return PxMat33.wrapPointer(Raw.getTranspose(this.address));
    }

    public PxMat33 getInverse() {
        this.checkNotNull();
        return PxMat33.wrapPointer(Raw.getInverse(this.address));
    }

    public float getDeterminant() {
        this.checkNotNull();
        return Raw.getDeterminant(this.address);
    }

    public PxVec3 transform(PxVec3 other) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.transform(this.address, other.getAddress()));
    }

    public PxVec3 transformTranspose(PxVec3 other) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.transformTranspose(this.address, other.getAddress()));
    }

    public static class Raw {
        public static native long PxMat33();

        public static native long PxMat33(int var0);

        public static native long PxMat33(long var0, long var2, long var4);

        public static native long PxMat33(float var0);

        public static native long PxMat33(long var0);

        public static native void destroy(long var0);

        public static native long getColumn0(long var0);

        public static native void setColumn0(long var0, long var2);

        public static native long getColumn1(long var0);

        public static native void setColumn1(long var0, long var2);

        public static native long getColumn2(long var0);

        public static native void setColumn2(long var0, long var2);

        public static native long getTranspose(long var0);

        public static native long getInverse(long var0);

        public static native float getDeterminant(long var0);

        public static native long transform(long var0, long var2);

        public static native long transformTranspose(long var0, long var2);
    }
}

