/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxTransform;
import physx.common.PxVec3;

public class PxPlane
extends NativeObject {
    public static final int SIZEOF = PxPlane.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxPlane wrapPointer(long address) {
        return address != 0L ? new PxPlane(address) : null;
    }

    public static PxPlane arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxPlane.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxPlane(long address) {
        super(address);
    }

    public static PxPlane createAt(long address) {
        Raw.PxPlane_placed(address);
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxPlane createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxPlane_placed(address);
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxPlane createAt(long address, float nx, float ny, float nz, float distance) {
        Raw.PxPlane_placed(address, nx, ny, nz, distance);
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxPlane createAt(T allocator, NativeObject.Allocator<T> allocate, float nx, float ny, float nz, float distance) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxPlane_placed(address, nx, ny, nz, distance);
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxPlane createAt(long address, PxVec3 normal, float distance) {
        Raw.PxPlane_placed(address, normal.getAddress(), distance);
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxPlane createAt(T allocator, NativeObject.Allocator<T> allocate, PxVec3 normal, float distance) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxPlane_placed(address, normal.getAddress(), distance);
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxPlane createAt(long address, PxVec3 p0, PxVec3 p1, PxVec3 p2) {
        Raw.PxPlane_placed(address, p0.getAddress(), p1.getAddress(), p2.getAddress());
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxPlane createAt(T allocator, NativeObject.Allocator<T> allocate, PxVec3 p0, PxVec3 p1, PxVec3 p2) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxPlane_placed(address, p0.getAddress(), p1.getAddress(), p2.getAddress());
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxPlane createAt(long address, PxVec3 point, PxVec3 normal) {
        PlatformChecks.requirePlatform(15, "physx.common.PxPlane");
        Raw.PxPlane_placed(address, point.getAddress(), normal.getAddress());
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxPlane createAt(T allocator, NativeObject.Allocator<T> allocate, PxVec3 point, PxVec3 normal) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxPlane_placed(address, point.getAddress(), normal.getAddress());
        PxPlane createdObj = PxPlane.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxPlane() {
        this.address = Raw.PxPlane();
    }

    public PxPlane(float nx, float ny, float nz, float distance) {
        this.address = Raw.PxPlane(nx, ny, nz, distance);
    }

    public PxPlane(PxVec3 normal, float distance) {
        this.address = Raw.PxPlane(normal.getAddress(), distance);
    }

    public PxPlane(PxVec3 p0, PxVec3 p1, PxVec3 p2) {
        this.address = Raw.PxPlane(p0.getAddress(), p1.getAddress(), p2.getAddress());
    }

    public PxPlane(PxVec3 point, PxVec3 normal) {
        PlatformChecks.requirePlatform(15, "physx.common.PxPlane");
        this.address = Raw.PxPlane(point.getAddress(), normal.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getN() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getN(this.address));
    }

    public void setN(PxVec3 value) {
        this.checkNotNull();
        Raw.setN(this.address, value.getAddress());
    }

    public float getD() {
        this.checkNotNull();
        return Raw.getD(this.address);
    }

    public void setD(float value) {
        this.checkNotNull();
        Raw.setD(this.address, value);
    }

    public float distance(PxVec3 p) {
        this.checkNotNull();
        return Raw.distance(this.address, p.getAddress());
    }

    public boolean contains(PxVec3 p) {
        this.checkNotNull();
        return Raw.contains(this.address, p.getAddress());
    }

    public PxVec3 project(PxVec3 p) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.project(this.address, p.getAddress()));
    }

    public PxVec3 pointInPlane() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.pointInPlane(this.address));
    }

    public void normalize() {
        this.checkNotNull();
        Raw.normalize(this.address);
    }

    public PxPlane transform(PxTransform pose) {
        this.checkNotNull();
        return PxPlane.wrapPointer(Raw.transform(this.address, pose.getAddress()));
    }

    public PxPlane inverseTransform(PxTransform pose) {
        this.checkNotNull();
        return PxPlane.wrapPointer(Raw.inverseTransform(this.address, pose.getAddress()));
    }

    public static class Raw {
        public static native void PxPlane_placed(long var0);

        public static native void PxPlane_placed(long var0, float var2, float var3, float var4, float var5);

        public static native void PxPlane_placed(long var0, long var2, float var4);

        public static native void PxPlane_placed(long var0, long var2, long var4, long var6);

        public static native void PxPlane_placed(long var0, long var2, long var4);

        public static native long PxPlane();

        public static native long PxPlane(float var0, float var1, float var2, float var3);

        public static native long PxPlane(long var0, float var2);

        public static native long PxPlane(long var0, long var2, long var4);

        public static native long PxPlane(long var0, long var2);

        public static native void destroy(long var0);

        public static native long getN(long var0);

        public static native void setN(long var0, long var2);

        public static native float getD(long var0);

        public static native void setD(long var0, float var2);

        public static native float distance(long var0, long var2);

        public static native boolean contains(long var0, long var2);

        public static native long project(long var0, long var2);

        public static native long pointInPlane(long var0);

        public static native void normalize(long var0);

        public static native long transform(long var0, long var2);

        public static native long inverseTransform(long var0, long var2);
    }
}

