/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;

public class PxStridedData
extends NativeObject {
    public static final int SIZEOF = PxStridedData.__sizeOf();
    public static final int ALIGNOF = 8;

    protected PxStridedData() {
    }

    private static native int __sizeOf();

    public static PxStridedData wrapPointer(long address) {
        return address != 0L ? new PxStridedData(address) : null;
    }

    public static PxStridedData arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxStridedData.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxStridedData(long address) {
        super(address);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public int getStride() {
        this.checkNotNull();
        return Raw.getStride(this.address);
    }

    public void setStride(int value) {
        this.checkNotNull();
        Raw.setStride(this.address, value);
    }

    public NativeObject getData() {
        this.checkNotNull();
        return NativeObject.wrapPointer(Raw.getData(this.address));
    }

    public void setData(NativeObject value) {
        this.checkNotNull();
        Raw.setData(this.address, value.getAddress());
    }

    public static class Raw {
        public static native void destroy(long var0);

        public static native int getStride(long var0);

        public static native void setStride(long var0, int var2);

        public static native long getData(long var0);

        public static native void setData(long var0, long var2);
    }
}

