/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxIDENTITYEnum;
import physx.common.PxQuat;
import physx.common.PxVec3;

public class PxTransform
extends NativeObject {
    public static final int SIZEOF = PxTransform.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxTransform wrapPointer(long address) {
        return address != 0L ? new PxTransform(address) : null;
    }

    public static PxTransform arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxTransform.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxTransform(long address) {
        super(address);
    }

    public static PxTransform createAt(long address) {
        Raw.PxTransform_placed(address);
        PxTransform createdObj = PxTransform.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxTransform createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxTransform_placed(address);
        PxTransform createdObj = PxTransform.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxTransform createAt(long address, PxIDENTITYEnum r) {
        Raw.PxTransform_placed(address, r.value);
        PxTransform createdObj = PxTransform.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxTransform createAt(T allocator, NativeObject.Allocator<T> allocate, PxIDENTITYEnum r) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxTransform_placed(address, r.value);
        PxTransform createdObj = PxTransform.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxTransform createAt(long address, PxVec3 p0, PxQuat q0) {
        Raw.PxTransform_placed(address, p0.getAddress(), q0.getAddress());
        PxTransform createdObj = PxTransform.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxTransform createAt(T allocator, NativeObject.Allocator<T> allocate, PxVec3 p0, PxQuat q0) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxTransform_placed(address, p0.getAddress(), q0.getAddress());
        PxTransform createdObj = PxTransform.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxTransform createAt(long address, PxVec3 position) {
        PlatformChecks.requirePlatform(15, "physx.common.PxTransform");
        Raw.PxTransform_placed(address, position.getAddress());
        PxTransform createdObj = PxTransform.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxTransform createAt(T allocator, NativeObject.Allocator<T> allocate, PxVec3 position) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxTransform_placed(address, position.getAddress());
        PxTransform createdObj = PxTransform.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxTransform() {
        this.address = Raw.PxTransform();
    }

    public PxTransform(PxIDENTITYEnum r) {
        this.address = Raw.PxTransform(r.value);
    }

    public PxTransform(PxVec3 p0, PxQuat q0) {
        this.address = Raw.PxTransform(p0.getAddress(), q0.getAddress());
    }

    public PxTransform(PxVec3 position) {
        PlatformChecks.requirePlatform(15, "physx.common.PxTransform");
        this.address = Raw.PxTransform(position.getAddress());
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxQuat getQ() {
        this.checkNotNull();
        return PxQuat.wrapPointer(Raw.getQ(this.address));
    }

    public void setQ(PxQuat value) {
        this.checkNotNull();
        Raw.setQ(this.address, value.getAddress());
    }

    public PxVec3 getP() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getP(this.address));
    }

    public void setP(PxVec3 value) {
        this.checkNotNull();
        Raw.setP(this.address, value.getAddress());
    }

    public PxTransform getInverse() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getInverse(this.address));
    }

    public PxVec3 transform(PxVec3 input) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.transform(this.address, input.getAddress()));
    }

    public PxVec3 transformInv(PxVec3 input) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.transformInv(this.address, input.getAddress()));
    }

    public boolean isValid() {
        this.checkNotNull();
        return Raw.isValid(this.address);
    }

    public boolean isSane() {
        this.checkNotNull();
        return Raw.isSane(this.address);
    }

    public boolean isFinite() {
        this.checkNotNull();
        return Raw.isFinite(this.address);
    }

    public PxTransform getNormalized() {
        this.checkNotNull();
        return PxTransform.wrapPointer(Raw.getNormalized(this.address));
    }

    public static class Raw {
        public static native void PxTransform_placed(long var0);

        public static native void PxTransform_placed(long var0, int var2);

        public static native void PxTransform_placed(long var0, long var2, long var4);

        public static native void PxTransform_placed(long var0, long var2);

        public static native long PxTransform();

        public static native long PxTransform(int var0);

        public static native long PxTransform(long var0, long var2);

        public static native long PxTransform(long var0);

        public static native void destroy(long var0);

        public static native long getQ(long var0);

        public static native void setQ(long var0, long var2);

        public static native long getP(long var0);

        public static native void setP(long var0, long var2);

        public static native long getInverse(long var0);

        public static native long transform(long var0, long var2);

        public static native long transformInv(long var0, long var2);

        public static native boolean isValid(long var0);

        public static native boolean isSane(long var0);

        public static native boolean isFinite(long var0);

        public static native long getNormalized(long var0);
    }
}

