/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;

public class PxVec3
extends NativeObject {
    public static final int SIZEOF = PxVec3.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVec3 wrapPointer(long address) {
        return address != 0L ? new PxVec3(address) : null;
    }

    public static PxVec3 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVec3.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVec3(long address) {
        super(address);
    }

    public static PxVec3 createAt(long address) {
        Raw.PxVec3_placed(address);
        PxVec3 createdObj = PxVec3.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxVec3 createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxVec3_placed(address);
        PxVec3 createdObj = PxVec3.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxVec3 createAt(long address, float x, float y, float z) {
        Raw.PxVec3_placed(address, x, y, z);
        PxVec3 createdObj = PxVec3.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxVec3 createAt(T allocator, NativeObject.Allocator<T> allocate, float x, float y, float z) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxVec3_placed(address, x, y, z);
        PxVec3 createdObj = PxVec3.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxVec3() {
        this.address = Raw.PxVec3();
    }

    public PxVec3(float x, float y, float z) {
        this.address = Raw.PxVec3(x, y, z);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getX() {
        this.checkNotNull();
        return Raw.getX(this.address);
    }

    public void setX(float value) {
        this.checkNotNull();
        Raw.setX(this.address, value);
    }

    public float getY() {
        this.checkNotNull();
        return Raw.getY(this.address);
    }

    public void setY(float value) {
        this.checkNotNull();
        Raw.setY(this.address, value);
    }

    public float getZ() {
        this.checkNotNull();
        return Raw.getZ(this.address);
    }

    public void setZ(float value) {
        this.checkNotNull();
        Raw.setZ(this.address, value);
    }

    public boolean isZero() {
        this.checkNotNull();
        return Raw.isZero(this.address);
    }

    public boolean isFinite() {
        this.checkNotNull();
        return Raw.isFinite(this.address);
    }

    public boolean isNormalized() {
        this.checkNotNull();
        return Raw.isNormalized(this.address);
    }

    public float magnitudeSquared() {
        this.checkNotNull();
        return Raw.magnitudeSquared(this.address);
    }

    public float magnitude() {
        this.checkNotNull();
        return Raw.magnitude(this.address);
    }

    public float dot(PxVec3 v) {
        this.checkNotNull();
        return Raw.dot(this.address, v.getAddress());
    }

    public PxVec3 cross(PxVec3 v) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.cross(this.address, v.getAddress()));
    }

    public PxVec3 getNormalized() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getNormalized(this.address));
    }

    public float normalize() {
        this.checkNotNull();
        return Raw.normalize(this.address);
    }

    public float normalizeSafe() {
        this.checkNotNull();
        return Raw.normalizeSafe(this.address);
    }

    public float normalizeFast() {
        this.checkNotNull();
        return Raw.normalizeFast(this.address);
    }

    public PxVec3 multiply(PxVec3 a) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.multiply(this.address, a.getAddress()));
    }

    public PxVec3 minimum(PxVec3 v) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.minimum(this.address, v.getAddress()));
    }

    public float minElement() {
        this.checkNotNull();
        return Raw.minElement(this.address);
    }

    public PxVec3 maximum(PxVec3 v) {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.maximum(this.address, v.getAddress()));
    }

    public float maxElement() {
        this.checkNotNull();
        return Raw.maxElement(this.address);
    }

    public PxVec3 abs() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.abs(this.address));
    }

    public static class Raw {
        public static native void PxVec3_placed(long var0);

        public static native void PxVec3_placed(long var0, float var2, float var3, float var4);

        public static native long PxVec3();

        public static native long PxVec3(float var0, float var1, float var2);

        public static native void destroy(long var0);

        public static native float getX(long var0);

        public static native void setX(long var0, float var2);

        public static native float getY(long var0);

        public static native void setY(long var0, float var2);

        public static native float getZ(long var0);

        public static native void setZ(long var0, float var2);

        public static native boolean isZero(long var0);

        public static native boolean isFinite(long var0);

        public static native boolean isNormalized(long var0);

        public static native float magnitudeSquared(long var0);

        public static native float magnitude(long var0);

        public static native float dot(long var0, long var2);

        public static native long cross(long var0, long var2);

        public static native long getNormalized(long var0);

        public static native float normalize(long var0);

        public static native float normalizeSafe(long var0);

        public static native float normalizeFast(long var0);

        public static native long multiply(long var0, long var2);

        public static native long minimum(long var0, long var2);

        public static native float minElement(long var0);

        public static native long maximum(long var0, long var2);

        public static native float maxElement(long var0);

        public static native long abs(long var0);
    }
}

