/*
 * Decompiled with CFR 0.152.
 */
package physx.common;

import physx.NativeObject;
import physx.common.PxVec3;

public class PxVec4
extends NativeObject {
    public static final int SIZEOF = PxVec4.__sizeOf();
    public static final int ALIGNOF = 8;

    private static native int __sizeOf();

    public static PxVec4 wrapPointer(long address) {
        return address != 0L ? new PxVec4(address) : null;
    }

    public static PxVec4 arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return PxVec4.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected PxVec4(long address) {
        super(address);
    }

    public static PxVec4 createAt(long address) {
        Raw.PxVec4_placed(address);
        PxVec4 createdObj = PxVec4.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxVec4 createAt(T allocator, NativeObject.Allocator<T> allocate) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxVec4_placed(address);
        PxVec4 createdObj = PxVec4.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static PxVec4 createAt(long address, float x, float y, float z, float w) {
        Raw.PxVec4_placed(address, x, y, z, w);
        PxVec4 createdObj = PxVec4.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> PxVec4 createAt(T allocator, NativeObject.Allocator<T> allocate, float x, float y, float z, float w) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.PxVec4_placed(address, x, y, z, w);
        PxVec4 createdObj = PxVec4.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public PxVec4() {
        this.address = Raw.PxVec4();
    }

    public PxVec4(float x, float y, float z, float w) {
        this.address = Raw.PxVec4(x, y, z, w);
    }

    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public float getX() {
        this.checkNotNull();
        return Raw.getX(this.address);
    }

    public void setX(float value) {
        this.checkNotNull();
        Raw.setX(this.address, value);
    }

    public float getY() {
        this.checkNotNull();
        return Raw.getY(this.address);
    }

    public void setY(float value) {
        this.checkNotNull();
        Raw.setY(this.address, value);
    }

    public float getZ() {
        this.checkNotNull();
        return Raw.getZ(this.address);
    }

    public void setZ(float value) {
        this.checkNotNull();
        Raw.setZ(this.address, value);
    }

    public float getW() {
        this.checkNotNull();
        return Raw.getW(this.address);
    }

    public void setW(float value) {
        this.checkNotNull();
        Raw.setW(this.address, value);
    }

    public boolean isZero() {
        this.checkNotNull();
        return Raw.isZero(this.address);
    }

    public boolean isFinite() {
        this.checkNotNull();
        return Raw.isFinite(this.address);
    }

    public boolean isNormalized() {
        this.checkNotNull();
        return Raw.isNormalized(this.address);
    }

    public float magnitudeSquared() {
        this.checkNotNull();
        return Raw.magnitudeSquared(this.address);
    }

    public float magnitude() {
        this.checkNotNull();
        return Raw.magnitude(this.address);
    }

    public float dot(PxVec4 v) {
        this.checkNotNull();
        return Raw.dot(this.address, v.getAddress());
    }

    public PxVec4 getNormalized() {
        this.checkNotNull();
        return PxVec4.wrapPointer(Raw.getNormalized(this.address));
    }

    public float normalize() {
        this.checkNotNull();
        return Raw.normalize(this.address);
    }

    public PxVec4 multiply(PxVec4 a) {
        this.checkNotNull();
        return PxVec4.wrapPointer(Raw.multiply(this.address, a.getAddress()));
    }

    public PxVec4 minimum(PxVec4 v) {
        this.checkNotNull();
        return PxVec4.wrapPointer(Raw.minimum(this.address, v.getAddress()));
    }

    public PxVec4 maximum(PxVec4 v) {
        this.checkNotNull();
        return PxVec4.wrapPointer(Raw.maximum(this.address, v.getAddress()));
    }

    public PxVec3 getXYZ() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getXYZ(this.address));
    }

    public static class Raw {
        public static native void PxVec4_placed(long var0);

        public static native void PxVec4_placed(long var0, float var2, float var3, float var4, float var5);

        public static native long PxVec4();

        public static native long PxVec4(float var0, float var1, float var2, float var3);

        public static native void destroy(long var0);

        public static native float getX(long var0);

        public static native void setX(long var0, float var2);

        public static native float getY(long var0);

        public static native void setY(long var0, float var2);

        public static native float getZ(long var0);

        public static native void setZ(long var0, float var2);

        public static native float getW(long var0);

        public static native void setW(long var0, float var2);

        public static native boolean isZero(long var0);

        public static native boolean isFinite(long var0);

        public static native boolean isNormalized(long var0);

        public static native float magnitudeSquared(long var0);

        public static native float magnitude(long var0);

        public static native float dot(long var0, long var2);

        public static native long getNormalized(long var0);

        public static native float normalize(long var0);

        public static native long multiply(long var0, long var2);

        public static native long minimum(long var0, long var2);

        public static native long maximum(long var0, long var2);

        public static native long getXYZ(long var0);
    }
}

