/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.common.PxVec3;
import physx.extensions.Support;

public class BoxSupport
extends Support {
    public static final int SIZEOF = BoxSupport.__sizeOf();
    public static final int ALIGNOF = 8;

    protected BoxSupport() {
    }

    private static native int __sizeOf();

    public static BoxSupport wrapPointer(long address) {
        return address != 0L ? new BoxSupport(address) : null;
    }

    public static BoxSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return BoxSupport.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected BoxSupport(long address) {
        super(address);
    }

    public static BoxSupport createAt(long address, PxVec3 halfExtents) {
        Raw.BoxSupport_placed(address, halfExtents.getAddress());
        BoxSupport createdObj = BoxSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> BoxSupport createAt(T allocator, NativeObject.Allocator<T> allocate, PxVec3 halfExtents) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.BoxSupport_placed(address, halfExtents.getAddress());
        BoxSupport createdObj = BoxSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static BoxSupport createAt(long address, PxVec3 halfExtents, float margin) {
        Raw.BoxSupport_placed(address, halfExtents.getAddress(), margin);
        BoxSupport createdObj = BoxSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> BoxSupport createAt(T allocator, NativeObject.Allocator<T> allocate, PxVec3 halfExtents, float margin) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.BoxSupport_placed(address, halfExtents.getAddress(), margin);
        BoxSupport createdObj = BoxSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public BoxSupport(PxVec3 halfExtents) {
        this.address = Raw.BoxSupport(halfExtents.getAddress());
    }

    public BoxSupport(PxVec3 halfExtents, float margin) {
        this.address = Raw.BoxSupport(halfExtents.getAddress(), margin);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxVec3 getHalfExtents() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getHalfExtents(this.address));
    }

    public void setHalfExtents(PxVec3 value) {
        this.checkNotNull();
        Raw.setHalfExtents(this.address, value.getAddress());
    }

    @Override
    public float getMargin() {
        this.checkNotNull();
        return Raw.getMargin(this.address);
    }

    public void setMargin(float value) {
        this.checkNotNull();
        Raw.setMargin(this.address, value);
    }

    public static class Raw {
        public static native void BoxSupport_placed(long var0, long var2);

        public static native void BoxSupport_placed(long var0, long var2, float var4);

        public static native long BoxSupport(long var0);

        public static native long BoxSupport(long var0, float var2);

        public static native void destroy(long var0);

        public static native long getHalfExtents(long var0);

        public static native void setHalfExtents(long var0, long var2);

        public static native float getMargin(long var0);

        public static native void setMargin(long var0, float var2);
    }
}

