/*
 * Decompiled with CFR 0.152.
 */
package physx.extensions;

import physx.NativeObject;
import physx.PlatformChecks;
import physx.common.PxQuat;
import physx.common.PxVec3;
import physx.extensions.Support;
import physx.geometry.PxConvexMesh;

public class ConvexMeshSupport
extends Support {
    public static final int SIZEOF = ConvexMeshSupport.__sizeOf();
    public static final int ALIGNOF = 8;

    protected ConvexMeshSupport() {
    }

    private static native int __sizeOf();

    public static ConvexMeshSupport wrapPointer(long address) {
        return address != 0L ? new ConvexMeshSupport(address) : null;
    }

    public static ConvexMeshSupport arrayGet(long baseAddress, int index) {
        if (baseAddress == 0L) {
            throw new NullPointerException("baseAddress is 0");
        }
        return ConvexMeshSupport.wrapPointer(baseAddress + (long)SIZEOF * (long)index);
    }

    protected ConvexMeshSupport(long address) {
        super(address);
    }

    public static ConvexMeshSupport createAt(long address, PxConvexMesh convexMesh) {
        Raw.ConvexMeshSupport_placed(address, convexMesh.getAddress());
        ConvexMeshSupport createdObj = ConvexMeshSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> ConvexMeshSupport createAt(T allocator, NativeObject.Allocator<T> allocate, PxConvexMesh convexMesh) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.ConvexMeshSupport_placed(address, convexMesh.getAddress());
        ConvexMeshSupport createdObj = ConvexMeshSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static ConvexMeshSupport createAt(long address, PxConvexMesh convexMesh, PxVec3 scale) {
        Raw.ConvexMeshSupport_placed(address, convexMesh.getAddress(), scale.getAddress());
        ConvexMeshSupport createdObj = ConvexMeshSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> ConvexMeshSupport createAt(T allocator, NativeObject.Allocator<T> allocate, PxConvexMesh convexMesh, PxVec3 scale) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.ConvexMeshSupport_placed(address, convexMesh.getAddress(), scale.getAddress());
        ConvexMeshSupport createdObj = ConvexMeshSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static ConvexMeshSupport createAt(long address, PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation) {
        Raw.ConvexMeshSupport_placed(address, convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress());
        ConvexMeshSupport createdObj = ConvexMeshSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> ConvexMeshSupport createAt(T allocator, NativeObject.Allocator<T> allocate, PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.ConvexMeshSupport_placed(address, convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress());
        ConvexMeshSupport createdObj = ConvexMeshSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static ConvexMeshSupport createAt(long address, PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation, float margin) {
        Raw.ConvexMeshSupport_placed(address, convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress(), margin);
        ConvexMeshSupport createdObj = ConvexMeshSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public static <T> ConvexMeshSupport createAt(T allocator, NativeObject.Allocator<T> allocate, PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation, float margin) {
        long address = allocate.on(allocator, 8, SIZEOF);
        Raw.ConvexMeshSupport_placed(address, convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress(), margin);
        ConvexMeshSupport createdObj = ConvexMeshSupport.wrapPointer(address);
        createdObj.isExternallyAllocated = true;
        return createdObj;
    }

    public ConvexMeshSupport(PxConvexMesh convexMesh) {
        this.address = Raw.ConvexMeshSupport(convexMesh.getAddress());
    }

    public ConvexMeshSupport(PxConvexMesh convexMesh, PxVec3 scale) {
        this.address = Raw.ConvexMeshSupport(convexMesh.getAddress(), scale.getAddress());
    }

    public ConvexMeshSupport(PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation) {
        this.address = Raw.ConvexMeshSupport(convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress());
    }

    public ConvexMeshSupport(PxConvexMesh convexMesh, PxVec3 scale, PxQuat scaleRotation, float margin) {
        this.address = Raw.ConvexMeshSupport(convexMesh.getAddress(), scale.getAddress(), scaleRotation.getAddress(), margin);
    }

    @Override
    public void destroy() {
        if (this.address == 0L) {
            throw new IllegalStateException(String.valueOf(this) + " is already deleted");
        }
        if (this.isExternallyAllocated) {
            throw new IllegalStateException(String.valueOf(this) + " is externally allocated and cannot be manually destroyed");
        }
        Raw.destroy(this.address);
        this.address = 0L;
    }

    public PxConvexMesh getConvexMesh() {
        this.checkNotNull();
        PlatformChecks.requirePlatform(15, "physx.extensions.ConvexMeshSupport");
        return PxConvexMesh.wrapPointer(Raw.getConvexMesh(this.address));
    }

    public PxVec3 getScale() {
        this.checkNotNull();
        return PxVec3.wrapPointer(Raw.getScale(this.address));
    }

    public void setScale(PxVec3 value) {
        this.checkNotNull();
        Raw.setScale(this.address, value.getAddress());
    }

    public PxQuat getScaleRotation() {
        this.checkNotNull();
        return PxQuat.wrapPointer(Raw.getScaleRotation(this.address));
    }

    public void setScaleRotation(PxQuat value) {
        this.checkNotNull();
        Raw.setScaleRotation(this.address, value.getAddress());
    }

    @Override
    public float getMargin() {
        this.checkNotNull();
        return Raw.getMargin(this.address);
    }

    public void setMargin(float value) {
        this.checkNotNull();
        Raw.setMargin(this.address, value);
    }

    public static class Raw {
        public static native void ConvexMeshSupport_placed(long var0, long var2);

        public static native void ConvexMeshSupport_placed(long var0, long var2, long var4);

        public static native void ConvexMeshSupport_placed(long var0, long var2, long var4, long var6);

        public static native void ConvexMeshSupport_placed(long var0, long var2, long var4, long var6, float var8);

        public static native long ConvexMeshSupport(long var0);

        public static native long ConvexMeshSupport(long var0, long var2);

        public static native long ConvexMeshSupport(long var0, long var2, long var4);

        public static native long ConvexMeshSupport(long var0, long var2, long var4, float var6);

        public static native void destroy(long var0);

        public static native long getConvexMesh(long var0);

        public static native long getScale(long var0);

        public static native void setScale(long var0, long var2);

        public static native long getScaleRotation(long var0);

        public static native void setScaleRotation(long var0, long var2);

        public static native float getMargin(long var0);

        public static native void setMargin(long var0, float var2);
    }
}

